@include('user.layout.header')
<style>
    /* Custom Styles for API Selling History - ST-InvestPro Theme Integration */
    :root {
        --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        --success-gradient: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
        --info-gradient: linear-gradient(135deg, #36d1dc 0%, #5b86e5 100%);
        --warning-gradient: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
        --danger-gradient: linear-gradient(135deg, #ff6b6b 0%, #ee5a24 100%);
        --card-shadow: 0 10px 30px rgba(0, 0, 0, 0.1);
        --border-radius: 15px;
        --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    body {
        background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
        font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
    }

    .history-container {
        padding: 40px 20px;
        min-height: 100vh;
        display: flex;
        align-items: flex-start;
        justify-content: center;
    }

    .history-card {
        background: rgba(255, 255, 255, 0.95);
        backdrop-filter: blur(20px);
        border-radius: var(--border-radius);
        box-shadow: var(--card-shadow);
        width: 100%;
        max-width: 1200px;
        position: relative;
        overflow: hidden;
        animation: slideUp 0.8s ease-out;
    }

    .history-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        height: 4px;
        background: var(--primary-gradient);
    }

    @keyframes slideUp {
        from { opacity: 0; transform: translateY(30px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .card-header {
        padding: 30px;
        background: linear-gradient(135deg, #f8f9ff 0%, #e8f4fd 100%);
        border-bottom: 1px solid rgba(102, 126, 234, 0.1);
        display: flex;
        align-items: center;
        justify-content: space-between;
        flex-wrap: wrap;
        gap: 15px;
    }

    .card-title {
        font-size: 2rem;
        font-weight: 700;
        background: var(--primary-gradient);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
        margin: 0;
        display: flex;
        align-items: center;
        gap: 12px;
    }

    .card-title i {
        font-size: 2.2rem;
        background: var(--primary-gradient);
        color: white;
        padding: 8px;
        border-radius: 50%;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    }

    .back-btn {
        background: var(--info-gradient);
        border: none;
        padding: 12px 24px;
        border-radius: 50px;
        font-size: 0.95rem;
        font-weight: 600;
        color: white;
        cursor: pointer;
        transition: var(--transition);
        box-shadow: 0 5px 20px rgba(91, 134, 229, 0.3);
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
    }

    .back-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 10px 30px rgba(91, 134, 229, 0.4);
        color: white;
    }

    .card-body {
        padding: 30px;
    }

    /* Table Styles */
    .history-table {
        width: 100%;
        border-collapse: separate;
        border-spacing: 0;
        background: white;
        border-radius: 12px;
        overflow: hidden;
        box-shadow: 0 5px 20px rgba(0, 0, 0, 0.08);
        margin-bottom: 30px;
    }

    .history-table thead {
        background: var(--primary-gradient);
        color: white;
    }

    .history-table th {
        padding: 18px 15px;
        text-align: left;
        font-weight: 600;
        font-size: 0.95rem;
        text-transform: uppercase;
        letter-spacing: 0.5px;
    }

    .history-table tbody tr {
        transition: var(--transition);
        border-bottom: 1px solid #f0f0f0;
    }

    .history-table tbody tr:hover {
        background: rgba(102, 126, 234, 0.05);
        transform: scale(1.01);
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.05);
    }

    .history-table td {
        padding: 18px 15px;
        vertical-align: middle;
        font-size: 0.95rem;
    }

    .link-cell {
        max-width: 200px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
    }

    .link-cell small {
        background: rgba(102, 126, 234, 0.1);
        padding: 6px 12px;
        border-radius: 20px;
        font-size: 0.85rem;
        color: #667eea;
        font-family: monospace;
        display: inline-block;
    }

    .earned-cell {
        font-size: 1.1rem;
        font-weight: 700;
    }

    .earned-cell strong {
        background: var(--success-gradient);
        -webkit-background-clip: text;
        -webkit-text-fill-color: transparent;
        background-clip: text;
    }

    /* Status Badges */
    .status-badge {
        padding: 8px 16px;
        border-radius: 25px;
        font-size: 0.85rem;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.5px;
        transition: var(--transition);
    }

    .badge-success {
        background: var(--success-gradient);
        color: white;
        box-shadow: 0 4px 15px rgba(17, 153, 142, 0.3);
    }

    .badge-warning {
        background: var(--warning-gradient);
        color: white;
        box-shadow: 0 4px 15px rgba(245, 87, 108, 0.3);
    }

    .badge-danger {
        background: var(--danger-gradient);
        color: white;
        box-shadow: 0 4px 15px rgba(238, 90, 36, 0.3);
    }

    /* Empty State */
    .empty-state {
        text-align: center;
        padding: 60px 40px;
        background: linear-gradient(135deg, #f8f9ff 0%, #e8f4fd 100%);
        border-radius: var(--border-radius);
        margin-bottom: 20px;
        animation: fadeIn 1s ease-out;
    }

    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(20px); }
        to { opacity: 1; transform: translateY(0); }
    }

    .empty-state i {
        font-size: 4rem;
        color: #bdc3c7;
        margin-bottom: 20px;
        display: block;
        animation: pulse 2s infinite;
    }

    @keyframes pulse {
        0%, 100% { transform: scale(1); }
        50% { transform: scale(1.1); }
    }

    .empty-state h5 {
        font-size: 1.8rem;
        font-weight: 600;
        color: #2c3e50;
        margin-bottom: 10px;
    }

    .empty-state p {
        color: #7f8c8d;
        font-size: 1.1rem;
        margin-bottom: 30px;
    }

    .start-btn {
        background: var(--primary-gradient);
        border: none;
        padding: 15px 30px;
        border-radius: 50px;
        font-size: 1rem;
        font-weight: 600;
        color: white;
        cursor: pointer;
        transition: var(--transition);
        box-shadow: 0 8px 25px rgba(102, 126, 234, 0.3);
        display: inline-flex;
        align-items: center;
        gap: 8px;
        text-decoration: none;
    }

    .start-btn:hover {
        transform: translateY(-2px);
        box-shadow: 0 12px 35px rgba(102, 126, 234, 0.4);
        color: white;
    }

    /* Pagination */
    .pagination-custom {
        display: flex;
        justify-content: center;
        margin-top: 40px;
    }

    .pagination-custom .pagination {
        margin: 0;
    }

    .pagination-custom .page-link {
        border: none;
        background: rgba(255, 255, 255, 0.8);
        color: #667eea;
        padding: 12px 16px;
        border-radius: 8px;
        margin: 0 2px;
        transition: var(--transition);
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
    }

    .pagination-custom .page-link:hover {
        background: var(--primary-gradient);
        color: white;
        transform: translateY(-1px);
    }

    .pagination-custom .page-item.active .page-link {
        background: var(--primary-gradient);
        color: white;
        border-color: transparent;
    }

    /* Responsive */
    @media (max-width: 768px) {
        .history-container { padding: 20px 15px; }
        .history-card { padding: 20px; }
        .card-header { flex-direction: column; text-align: center; }
        .history-table { font-size: 0.9rem; }
        .history-table th, .history-table td { padding: 12px 8px; }
        .link-cell { max-width: 150px; }
        .empty-state { padding: 40px 20px; }
    }
</style>
<br><br><br>
<style>
    /* Premium Ad Card Styles */
    .premium-ad-card {
        background: white;
        border-radius: 16px;
        padding: 10px;
        margin: 15px auto;
        position: relative;
        overflow: hidden;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        border: 1px solid rgba(0, 0, 0, 0.04);
        display: flex;
        align-items: center;
        gap: 12px;
        max-width: 100%;
        transition: transform 0.2s ease, box-shadow 0.2s ease;
        text-decoration: none; /* Remove underline from link */
    }

    /* Hover Effect */
    .premium-ad-card:active {
        transform: scale(0.98);
    }

    /* Shining Animation Effect (Eye Catcher) */
    .premium-ad-card::before {
        content: '';
        position: absolute;
        top: 0;
        left: -100%;
        width: 50%;
        height: 100%;
        background: linear-gradient(to right, transparent, rgba(255, 255, 255, 0.8), transparent);
        transform: skewX(-25deg);
        animation: shine 3s infinite;
        pointer-events: none;
    }

    @keyframes shine {
        100% { left: 200%; }
    }

    /* Label Badge */
    .ad-badge {
        position: absolute;
        top: 0;
        left: 0;
        background: linear-gradient(135deg, #FF9800 0%, #F57C00 100%);
        color: white;
        font-size: 9px;
        font-weight: 700;
        padding: 2px 8px;
        border-bottom-right-radius: 8px;
        border-top-left-radius: 16px; /* Matches card corner */
        z-index: 2;
        letter-spacing: 0.5px;
    }

    /* Image Styling */
    .ad-image-wrapper {
        width: 80px; /* Fixed width for consistency */
        height: 60px; /* Compact height */
        border-radius: 10px;
        overflow: hidden;
        flex-shrink: 0;
        background: #f0f0f0;
    }

    .ad-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    /* Content Styling */
    .ad-content {
        flex: 1;
        display: flex;
        flex-direction: column;
        justify-content: center;
    }

    .ad-title {
        font-size: 14px;
        font-weight: 600;
        color: #1f2937;
        margin-bottom: 2px;
        line-height: 1.2;
    }

    .ad-cta {
        font-size: 11px;
        color: #229ED9; /* Telegram Blue */
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 4px;
    }
    
    .ad-arrow-icon {
        width: 18px;
        height: 18px;
        background: #e0f2fe;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 10px;
    }
</style>

@php
    $activeAd = \App\Models\Ad::active()->first();
    
    // যখনি অ্যাডটি লোড হবে, ভিউ বা ইম্প্রেশন ১ বাড়বে
    if($activeAd){
        $activeAd->increment('views');
    }
@endphp

@if($activeAd)
    {{-- Active Ad Section --}}
    <a href="{{ route('ad.track.click', $activeAd->id) }}" target="_blank" class="premium-ad-card">
        <span class="ad-badge">SPONSORED</span>
        
        <div class="ad-image-wrapper">
            <img src="{{ asset('ads_images/' . $activeAd->image) }}" alt="{{ $activeAd->ad_name ?: 'Exclusive Offer For You' }}" class="ad-image">
        </div>
        
        <div class="ad-content">
            {{-- এই লাইনটি আপডেট করা হয়েছে --}}
            <div class="ad-title">{{ $activeAd->ad_name ?: 'Exclusive Offer For You' }}</div>
            
            <div class="ad-cta">
                Click to View 
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
@else
    {{-- Default/Fallback Section --}}
    <a href="/ads/create" target="_blank" class="premium-ad-card">
        <span class="ad-badge">Ads Offer</span>
        
        <div class="ad-image-wrapper">
            <img src="{{ asset('ads_images/ads.jpg') }}" alt="Offer" class="ad-image">
        </div>
        
        <div class="ad-content">
            <div class="ad-title">Run Your Ads And Grow Your Team</div>
            <div class="ad-cta">
                Click to Run
                <div class="ad-arrow-icon"><i class="fas fa-chevron-right"></i></div>
            </div>
        </div>
    </a>
@endif
<div class="history-container">
    <div class="history-card">
        <div class="card-header">
            <h1 class="card-title">
                <i class="fas fa-history"></i>
                API Selling Work History
            </h1>
            <a href="{{ route('api.selling') }}" class="back-btn">
                <i class="fas fa-arrow-left"></i> Back to API Selling
            </a>
        </div>
        <div class="card-body">
            @if($histories->count() > 0)
                <div class="table-responsive">
                    <table class="history-table">
                        <thead>
                            <tr>
                                <th><i class="fas fa-clock me-2"></i>Date & Time</th>
                                <th><i class="fas fa-link me-2"></i>Telegram Link</th>
                                <th><i class="fas fa-coins me-2"></i>Earned Amount</th>
                                <th><i class="fas fa-check-circle me-2"></i>Status</th>
                                <th><i class="fas fa-calendar-check me-2"></i>Completed At</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($histories as $history)
                                <tr>
                                    <td>{{ $history->created_at->format('d M Y, h:i A') }}</td>
                                    <td class="link-cell">
                                        <small>{{ $history->telegram_link }}</small>
                                    </td>
                                    <td class="earned-cell">
                                        <strong>৳{{ number_format($history->earned_amount, 2) }}</strong>
                                    </td>
                                    <td>
                                        @if($history->status == 'completed')
                                            <span class="status-badge badge-success">Completed</span>
                                        @elseif($history->status == 'pending')
                                            <span class="status-badge badge-warning">Pending</span>
                                        @else
                                            <span class="status-badge badge-danger">Failed</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($history->completed_at)
                                            {{ $history->completed_at->format('d M Y, h:i A') }}
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
               
                <!-- Pagination -->
                <div class="pagination-custom">
                    {{ $histories->links() }}
                </div>
            @else
                <div class="empty-state">
                    <i class="fas fa-history"></i>
                    <h5>No Work History Found</h5>
                    <p>You haven't completed any API tasks yet. Start earning today!</p>
                    <a href="{{ route('api.selling') }}" class="start-btn">
                        <i class="fas fa-bolt"></i> Start API Selling
                    </a>
                </div>
            @endif
        </div>
    </div>
</div>

@include('user.layout.footer')