@include('user.layout.header')

<style>
    /* Telegram Light Theme Variables */
    :root {
        --tg-bg: #f1f2f6; /* টেলিগ্রামের ব্যাকগ্রাউন্ড কালার */
        --tg-white: #ffffff;
        --tg-blue: #3390ec; /* টেলিগ্রামের সিগনেচার আকাশি কালার */
        --tg-text: #222222;
        --tg-gray: #707579;
        --tg-border: #dfe1e5;
    }

    body {
        background-color: var(--tg-bg);
        font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, Helvetica, Arial, sans-serif;
        color: var(--tg-text);
    }

    /* মেইন কার্ড ডিজাইন */
    .tg-card {
        background-color: var(--tg-white);
        border-radius: 12px;
        box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        border: none;
        margin-top: 30px;
        overflow: hidden; /* রাউন্ডেড কর্নারের জন্য */
    }

    /* হেডার সেকশন */
    .tg-header {
        background-color: var(--tg-white);
        padding: 20px 25px;
        border-bottom: 1px solid var(--tg-border);
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .tg-title {
        font-size: 20px;
        font-weight: 600;
        color: var(--tg-text);
        margin: 0;
    }

    /* টেলিগ্রাম স্টাইল বাটন (আকাশি) */
    .btn-tg-primary {
        background-color: var(--tg-blue);
        color: #fff;
        border: none;
        border-radius: 8px; /* টেলিগ্রামের মতো হালকা রাউন্ড */
        padding: 10px 20px;
        font-weight: 500;
        font-size: 14px;
        transition: all 0.2s;
        box-shadow: 0 2px 5px rgba(51, 144, 236, 0.3);
    }

    .btn-tg-primary:hover {
        background-color: #2880ca;
        color: #fff;
        transform: translateY(-1px);
        box-shadow: 0 4px 8px rgba(51, 144, 236, 0.4);
    }

    /* টেবিল ডিজাইন */
    .table-tg {
        width: 100%;
        margin-bottom: 0;
    }

    .table-tg thead th {
        background-color: #f7f9fa; /* খুব হালকা আকাশি/ধূসর */
        color: var(--tg-gray);
        font-weight: 600;
        font-size: 13px;
        text-transform: uppercase;
        border-bottom: 1px solid var(--tg-border);
        border-top: none;
        padding: 15px;
    }

    .table-tg tbody td {
        padding: 15px;
        vertical-align: middle;
        border-bottom: 1px solid #f0f0f0;
        color: var(--tg-text);
        font-size: 14px;
    }

    .table-tg tbody tr:hover {
        background-color: #f4f6f8; /* হোভার করলে হালকা কালার */
    }

    /* ইমেজ স্টাইল */
    .ad-thumb {
        width: 60px;
        height: 60px;
        object-fit: cover;
        border-radius: 8px;
        border: 1px solid #eee;
    }

    /* স্ট্যাটস এবং টেক্সট ডিজাইন */
    .stat-item {
        font-size: 12px;
        padding: 4px 8px;
        border-radius: 4px;
        background: #eef6fc; /* হালকা নীল ব্যাকগ্রাউন্ড */
        color: var(--tg-blue);
        display: inline-block;
        margin-bottom: 2px;
        font-weight: 500;
    }

    .link-text {
        color: var(--tg-blue);
        text-decoration: none;
        font-weight: 500;
    }

    /* স্ট্যাটাস ব্যাজ */
    .badge-tg {
        padding: 5px 10px;
        border-radius: 6px;
        font-size: 12px;
        font-weight: 600;
    }
    .badge-tg-success { background-color: #e6fcf5; color: #0ca678; }
    .badge-tg-warning { background-color: #fff9db; color: #f59f00; }
    .badge-tg-danger  { background-color: #fff5f5; color: #fa5252; }

    /* সময় এবং তারিখ */
    .date-text {
        font-size: 12px;
        color: var(--tg-gray);
    }
</style>
<br><br><br>
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-12 col-lg-11">
            
            <div class="tg-card">
                <div class="tg-header">
                    <div>
                        <h3 class="tg-title">📢 My Ads List</h3>
                    </div>
                    <a href="{{ route('ads.create') }}" class="btn-tg-primary">
                        <i class="fas fa-plus"></i> Create New Ad
                    </a>
                </div>

                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-tg">
                            <thead>
                                <tr>
                                    <th>Image</th>
                                    <th>Performance</th>
                                    <th>Link Info</th>
                                    <th>Duration & Cost</th>
                                    <th>Status</th>
                                    <th>Schedule</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($ads as $ad)
                                <tr>
                                    <td>
                                        <img src="{{ asset('ads_images/' . $ad->image) }}" alt="Ad Image" class="ad-thumb">
                                    </td>

                                    <td>
                                        <div class="stat-item"><i class="fas fa-eye"></i> {{ $ad->views }} Views</div><br>
                                        <div class="stat-item" style="margin-top:4px;"><i class="fas fa-mouse-pointer"></i> {{ $ad->clicks }} Clicks</div>
                                    </td>

                                    <td>
                                        <a href="{{ $ad->link }}" target="_blank" class="link-text">{{ Str::limit($ad->link, 20) }}</a>
                                        <div class="date-text">Created: {{ $ad->created_at->format('d M, Y') }}</div>
                                    </td>

                                    <td>
                                        <span style="font-weight: bold; color: #333;">৳{{ $ad->amount }}</span>
                                        <br>
                                        <span class="date-text">{{ $ad->duration_hours }} Hours</span>
                                    </td>

                                    <td>
                                        @if($ad->status == 'approved')
                                            <span class="badge-tg badge-tg-success">Approved</span>
                                        @elseif($ad->status == 'pending')
                                            <span class="badge-tg badge-tg-warning">Pending</span>
                                        @else
                                            <span class="badge-tg badge-tg-danger">Rejected</span>
                                        @endif
                                    </td>

                                    <td>
                                        <div class="date-text">Start: {{ $ad->start_time ? $ad->start_time->format('d M, h:i A') : '--' }}</div>
                                        <div class="date-text">End: {{ $ad->end_time ? $ad->end_time->format('d M, h:i A') : '--' }}</div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    @if($ads->isEmpty())
                        <div class="text-center p-5">
                            <i class="fas fa-box-open fa-3x" style="color: #dfe1e5;"></i>
                            <p style="color: #707579; margin-top: 10px;">No ads created yet.</p>
                        </div>
                    @endif
                </div>
            </div>

        </div>
    </div>
</div>

@include('user.layout.footer')