<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>স্বাগতম! আপনার অ্যাকাউন্ট তৈরি হয়েছে</title>
    <style>
        /* বেসিক রিসেট */
        body {
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background-color: #f0f2f5;
            /* গ্লাসমরফিজমের জন্য ব্যাকগ্রাউন্ড গ্র্যাডিয়েন্ট */
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            background-repeat: no-repeat;
            background-attachment: fixed;
            height: 100%;
            width: 100%;
        }

        /* মেইন কন্টেইনার - গ্লাস ইফেক্ট */
        .glass-container {
            max-width: 600px;
            margin: 40px auto;
            background: rgba(255, 255, 255, 0.90); /* স্বচ্ছতা */
            backdrop-filter: blur(10px); /* ব্লার ইফেক্ট (সাপোর্টেড ডিভাইসে) */
            -webkit-backdrop-filter: blur(10px);
            border-radius: 16px;
            border: 1px solid rgba(255, 255, 255, 0.3);
            box-shadow: 0 8px 32px 0 rgba(31, 38, 135, 0.15);
            overflow: hidden;
        }

        .header {
            text-align: center;
            padding: 40px 20px 20px 20px;
            border-bottom: 1px solid rgba(0, 0, 0, 0.05);
        }

        .header h1 {
            color: #4a4a4a;
            margin: 0;
            font-size: 26px;
            font-weight: 700;
            letter-spacing: -0.5px;
        }

        .header p {
            color: #666;
            margin-top: 5px;
            font-size: 16px;
        }

        .content {
            padding: 30px;
        }

        .welcome-msg {
            font-size: 16px;
            color: #555;
            line-height: 1.8;
            text-align: center;
            margin-bottom: 30px;
        }

        /* ইউজার ইনফো কার্ড */
        .info-card {
            background: rgba(255, 255, 255, 0.6);
            border: 1px solid rgba(102, 126, 234, 0.2);
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 30px;
        }

        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 12px 0;
            border-bottom: 1px dashed #d1d1d1;
            font-size: 15px;
        }

        .info-row:last-child {
            border-bottom: none;
        }

        .info-label {
            color: #777;
            font-weight: 600;
        }

        .info-value {
            color: #333;
            font-weight: 500;
            text-align: right;
        }

        .highlight-code {
            background: #eef2ff;
            color: #667eea;
            padding: 2px 8px;
            border-radius: 4px;
            font-weight: bold;
            font-family: monospace;
            font-size: 16px;
        }

        /* বাটন ডিজাইন */
        .btn-container {
            text-align: center;
            margin: 35px 0;
        }

        .btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: #ffffff !important;
            text-decoration: none;
            padding: 14px 40px;
            border-radius: 50px;
            font-weight: 600;
            font-size: 16px;
            box-shadow: 0 4px 15px rgba(102, 126, 234, 0.4);
            transition: transform 0.2s;
            display: inline-block;
        }
        
        .btn:hover {
            opacity: 0.9;
        }

        /* টিপস সেকশন */
        .tip-box {
            background: rgba(255, 248, 225, 0.7);
            border-left: 4px solid #ffc107;
            padding: 15px;
            border-radius: 8px;
            font-size: 14px;
            color: #666;
            margin-top: 20px;
        }

        .footer {
            background: rgba(248, 249, 250, 0.8);
            padding: 20px;
            text-align: center;
            font-size: 13px;
            color: #888;
            border-top: 1px solid rgba(0, 0, 0, 0.05);
        }

        .footer a {
            color: #667eea;
            text-decoration: none;
            margin: 0 5px;
        }

        /* মোবাইল রেসপন্সিভ */
        @media only screen and (max-width: 600px) {
            .glass-container {
                margin: 20px;
                width: auto;
            }
            .content {
                padding: 20px;
            }
            .info-row {
                flex-direction: column;
                text-align: left;
            }
            .info-value {
                text-align: left;
                margin-top: 5px;
            }
        }
    </style>
</head>
<body>
    <div class="glass-container">
        <div class="header">
            <h1>🎉 অভিনন্দন!</h1>
            <p>আপনার অ্যাকাউন্ট সফলভাবে তৈরি হয়েছে</p>
        </div>
        
        <div class="content">
            <div class="welcome-msg">
                প্রিয় <strong>{{ $user->fname ?? 'User' }}</strong>,<br>
                আমাদের পরিবারে আপনাকে স্বাগতম। আপনার রেজিস্ট্রেশন প্রক্রিয়াটি সফলভাবে সম্পন্ন হয়েছে। এখন আপনি আমাদের সকল সেবা উপভোগ করতে পারবেন।
            </div>

            <div class="info-card">
                <div class="info-row">
                    <span class="info-label">ইমেইল</span>
                    <span class="info-value">{{ $user->email }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">ফোন</span>
                    <span class="info-value">{{ $user->phone }}</span>
                </div>
                <div class="info-row">
                    <span class="info-label">রেফারেল কোড</span>
                    <span class="info-value"><span class="highlight-code">{{ $user->ref_code }}</span></span>
                </div>
                <div class="info-row">
                    <span class="info-label">যোগদানের তারিখ</span>
                    <span class="info-value">{{ $user->created_at->format('d M Y') }}</span>
                </div>
            </div>

            <div class="btn-container">
                <a href="{{ $loginUrl }}" class="btn">লগইন করুন</a>
            </div>

            <div class="tip-box">
                <strong>💡 টিপ:</strong> আপনার রেফারেল কোডটি বন্ধুদের সাথে শেয়ার করুন। তারা জয়েন করলে আপনি ভবিষ্যতে বিশেষ সুবিধা বা রিওয়ার্ড পেতে পারেন।
            </div>
        </div>

        <div class="footer">
            <p>
                <a href="#">ওয়েবসাইট</a> • 
                <a href="#">সাপোর্ট</a> • 
                <a href="#">প্রাইভেসি পলিসি</a>
            </p>
            <p style="margin-top: 10px;">
                © {{ date('Y') }} {{ config('app.name') }}. সকল অধিকার সংরক্ষিত।<br>
                এটি একটি অটোমেটেড ইমেইল, দয়া করে রিপ্লাই দিবেন না।
            </p>
        </div>
    </div>
</body>
</html>