<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>পেমেন্ট সফল! আপনার অ্যাকাউন্ট এক্টিভেট করা হয়েছে</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            margin: 0;
            padding: 0;
            background-color: #f4f4f4;
        }
        .container {
            max-width: 600px;
            margin: 0 auto;
            background: #ffffff;
            border-radius: 15px;
            overflow: hidden;
            box-shadow: 0 0 30px rgba(0,0,0,0.1);
        }
        .header {
            background: linear-gradient(135deg, #00b09b 0%, #96c93d 100%);
            color: white;
            padding: 40px 20px;
            text-align: center;
        }
        .header h1 {
            margin: 0;
            font-size: 32px;
            font-weight: 700;
        }
        .header p {
            margin: 10px 0 0 0;
            font-size: 18px;
            opacity: 0.9;
        }
        .content {
            padding: 40px 30px;
        }
        .success-icon {
            text-align: center;
            font-size: 80px;
            margin-bottom: 20px;
        }
        .greeting {
            font-size: 20px;
            color: #2c3e50;
            margin-bottom: 30px;
            text-align: center;
        }
        .payment-details {
            background: #f8f9fa;
            padding: 25px;
            border-radius: 10px;
            margin: 25px 0;
            border-left: 5px solid #00b09b;
        }
        .detail-item {
            display: flex;
            justify-content: space-between;
            margin-bottom: 12px;
            padding-bottom: 12px;
            border-bottom: 1px solid #e9ecef;
        }
        .detail-item:last-child {
            border-bottom: none;
            margin-bottom: 0;
            padding-bottom: 0;
        }
        .detail-label {
            font-weight: 600;
            color: #495057;
        }
        .detail-value {
            font-weight: 700;
            color: #00b09b;
        }
        .features {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 25px;
            border-radius: 10px;
            margin: 25px 0;
        }
        .features h3 {
            margin-top: 0;
            text-align: center;
            font-size: 22px;
        }
        .feature-list {
            list-style: none;
            padding: 0;
        }
        .feature-list li {
            padding: 8px 0;
            display: flex;
            align-items: center;
        }
        .feature-list li:before {
            content: "✓";
            margin-right: 10px;
            background: white;
            color: #667eea;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            font-size: 12px;
            font-weight: bold;
        }
        .cta-button {
            text-align: center;
            margin: 30px 0;
        }
        .btn {
            display: inline-block;
            background: linear-gradient(135deg, #00b09b 0%, #96c93d 100%);
            color: white;
            padding: 15px 40px;
            text-decoration: none;
            border-radius: 30px;
            font-weight: 700;
            font-size: 18px;
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            box-shadow: 0 4px 15px rgba(0, 176, 155, 0.3);
        }
        .btn:hover {
            transform: translateY(-3px);
            box-shadow: 0 6px 20px rgba(0, 176, 155, 0.4);
        }
        .next-steps {
            background: #fff3cd;
            padding: 20px;
            border-radius: 10px;
            border-left: 5px solid #ffc107;
            margin: 25px 0;
        }
        .next-steps h4 {
            margin-top: 0;
            color: #856404;
        }
        .footer {
            background: #2c3e50;
            color: white;
            padding: 30px 20px;
            text-align: center;
        }
        .support-info {
            margin: 20px 0;
        }
        .support-info a {
            color: #00b09b;
            text-decoration: none;
        }
        .copyright {
            margin-top: 20px;
            padding-top: 20px;
            border-top: 1px solid rgba(255,255,255,0.1);
            font-size: 14px;
            opacity: 0.8;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>🎉 পেমেন্ট সফল!</h1>
            <p>আপনার অ্যাকাউন্ট সফলভাবে এক্টিভেট করা হয়েছে</p>
        </div>
        
        <div class="content">
            <div class="success-icon">✅</div>
            
            <div class="greeting">
                প্রিয় <strong>{{ $user->fname ?? 'User' }}</strong>,<br>
                আপনার পেমেন্ট সফলভাবে প্রসেস করা হয়েছে এবং অ্যাকাউন্ট এক্টিভেট করা হয়েছে!
            </div>

            <div class="payment-details">
                <h3 style="margin-top: 0; color: #00b09b; text-align: center;">পেমেন্ট বিবরণ</h3>
                
                <div class="detail-item">
                    <span class="detail-label">লেনদেন আইডি:</span>
                    <span class="detail-value">{{ $paymentData['transaction_id'] }}</span>
                </div>
                
                <div class="detail-item">
                    <span class="detail-label">পেমেন্ট Amount:</span>
                    <span class="detail-value">৳{{ number_format($paymentData['amount'], 2) }}</span>
                </div>
                
                <div class="detail-item">
                    <span class="detail-label">পেমেন্ট Method:</span>
                    <span class="detail-value">Tele-Earn</span>
                </div>
                
                <div class="detail-item">
                    <span class="detail-label">স্ট্যাটাস:</span>
                    <span class="detail-value" style="color: #28a745;">✅ Approved</span>
                </div>
                
                <div class="detail-item">
                    <span class="detail-label">তারিখ ও সময়:</span>
                    <span class="detail-value">{{ now()->format('d M Y, h:i A') }}</span>
                </div>
            </div>

            <div class="features">
                <h3>🚀 এখন আপনি যা যা করতে পারবেন:</h3>
                <ul class="feature-list">
                    <li>ফুল এক্সেস ড্যাশবোর্ড</li>
                    <li>৫টি জব লিমিট সহ কাজ শুরু করুন</li>
                    <li>প্রিমিয়াম ফিচারগুলো এক্সেস করুন</li>
                    <li>আপনার রেফারেল লিংক শেয়ার করুন</li>
                    <li>ব্যালেন্স ম্যানেজমেন্ট</li>
                </ul>
            </div>

            <div class="next-steps">
                <h4>📝 পরবর্তী ধাপ:</h4>
                <p>আপনার ড্যাশবোর্ডে লগইন করে এখনই কাজ শুরু করুন। আপনার অ্যাকাউন্টে ৫টি জব লিমিট অটোমেটিক্যালি যোগ করা হয়েছে।</p>
            </div>

            <div class="cta-button">
                <a href="{{ $dashboardUrl }}" class="btn">ড্যাশবোর্ড এক্সেস করুন</a>
            </div>

            <div style="text-align: center; color: #6c757d; font-size: 14px;">
                <p>যদি আপনার কোনো প্রশ্ন থাকে বা সাহায্যের প্রয়োজন হয়, তাহলে আমাদের সাপোর্ট টিমের সাথে যোগাযোগ করতে দ্বিধা করবেন না।</p>
            </div>
        </div>

        <div class="footer">
            <div class="support-info">
                <strong>সাপোর্ট টিম:</strong><br>
                📧 Email: <a href="mailto:support@tele-earn.com">support@tele-earn.com</a><br>
                📞 Phone: <a href="tel:+8801533661719">+880 1533661719</a>
            </div>
            <div class="copyright">
                © {{ date('Y') }} {{ config('app.name') }}. সকল অধিকার সংরক্ষিত।<br>
                এটি একটি অটোমেটেড ইমেইল, অনুগ্রহ করে রিপ্লাই দিবেন না।
            </div>
        </div>
    </div>
</body>
</html>