@extends('layouts.main-layout')


@section('body')

<style>
    .copy-btn {
  display: inline-block;
  margin-bottom: 15px;
  padding: 10px 20px;
  background: linear-gradient(45deg, #ff8c00, #ffb347); /* warm orange-yellow gradient */
  color: #fff;
  font-weight: 600;
  border: none;
  border-radius: 6px;
  cursor: pointer;
  box-shadow: 0 4px 8px rgba(255, 140, 0, 0.4);
  transition: background 0.3s ease, box-shadow 0.3s ease;
  user-select: none;
  font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
  letter-spacing: 0.05em;
}

.copy-btn:hover {
  background: linear-gradient(45deg, #ffb347, #ff8c00);
  box-shadow: 0 6px 12px rgba(255, 140, 0, 0.6);
}

.copy-btn:active {
  background: #e67300;
  box-shadow: inset 0 3px 5px rgba(0,0,0,0.2);
}

</style>
           <div class="withdrawals-section">
    <div class="withdrawals-wrapper">
        <div class="withdrawals-card">
            <div class="withdrawals-card-body">
                <div class="withdrawals-table-container">
                    <button id="copyPendingBtn" class="copy-btn">Copy All Pending Withdrawals</button>
                    <br>

                    <table id="withdrawalsTable" class="withdrawals-table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Date</th>
                                <th>Method</th>
                                <th>Number</th>
                                <th>Charges</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($data as $item)
                                <tr class="text-center">
                                    <td>{{ $item->id }}</td>
                                    <td>{{ \Carbon\Carbon::parse($item->created_at)->format('d.m.Y') }}</td>
                                    <td>{{ $item->method }}</td>
                                    <td>{{ $item->wallet }}</td>
                                    <td>{{ $item->charges }}</td>
                                    <td>{{ $item->amount }}</td>
                                    <td>
                                        <span class="status-badge 
                                            {{ $item->status === 'Success' ? 'status-success' : ($item->status === 'Pending' ? 'status-pending' : 'status-failed') }}">
                                            {{ $item->status }}
                                        </span>
                                    </td>
                                    <td>
                                        <a href="{{ route('WithdrawPaid', $item->id) }}" class="btn-action success-action">PAID</a> /
                                        <a href="{{ route('WithdrawFailed', $item->id) }}" class="btn-action failed-action">FAILED</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>                </div>             </div>         </div>     </div> </div>
<script>
document.getElementById('copyPendingBtn').addEventListener('click', function() {
    const rows = document.querySelectorAll('#withdrawalsTable tbody tr');
    
    let pendingTexts = [];
    let serial = 1;

    rows.forEach(row => {
        // Find the status cell text
        const statusCell = row.querySelector('td:nth-child(7) .status-badge');
        if(statusCell && statusCell.textContent.trim() === 'Pending') {
            // Extract method, wallet, amount
            const method = row.querySelector('td:nth-child(3)').textContent.trim();
            const wallet = row.querySelector('td:nth-child(4)').textContent.trim();
            const amount = row.querySelector('td:nth-child(6)').textContent.trim();

            pendingTexts.push(`${serial}. Method: ${method}, Wallet: ${wallet}, Amount: ${amount}`);
            serial++;
        }
    });

    if(pendingTexts.length === 0) {
        alert('No pending withdrawals found.');
        return;
    }

    
    const textToCopy = pendingTexts.join('\n');

   
    navigator.clipboard.writeText(textToCopy).then(() => {
        alert('Pending withdrawals copied to clipboard!');
    }).catch(() => {
        alert('Failed to copy. Please copy manually:\n' + textToCopy);
    });
});
</script>

<style>
    .withdrawals-section {
    padding: 25px;
    background: #f7f9fc;
}

.withdrawals-wrapper {
    background: #ffffff;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.06);
}

.withdrawals-card-body {
    padding: 20px;
}

.withdrawals-table-container {
    overflow-x: auto;
}

.withdrawals-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 14px;
}

.withdrawals-table thead {
    background-color: #3949ab;
    color: #fff;
}

.withdrawals-table th,
.withdrawals-table td {
    padding: 12px;
    border: 1px solid #eaeaea;
    text-align: center;
}

.withdrawals-table tr:hover {
    background-color: #f1f1f1;
}

/* Status Badges */
.status-badge {
    padding: 5px 10px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: bold;
    display: inline-block;
}

.status-success {
    background-color: #e8f5e9;
    color: #2e7d32;
}

.status-pending {
    background-color: #fff3cd;
    color: #856404;
}

.status-failed {
    background-color: #f8d7da;
    color: #721c24;
}

/* Action Buttons */
.btn-action {
    padding: 4px 10px;
    font-size: 13px;
    border-radius: 5px;
    text-decoration: none;
    font-weight: 600;
    transition: 0.2s;
}

.success-action {
    background-color: #4caf50;
    color: white;
}

.failed-action {
    background-color: #f44336;
    color: white;
}

.btn-action:hover {
    opacity: 0.8;
}

/* Responsive */
@media (max-width: 768px) {
    .withdrawals-card-body {
        padding: 10px;
    }

    .withdrawals-table th,
    .withdrawals-table td {
        font-size: 12px;
        padding: 8px;
    }
}

</style>
<script>
   function _0x5804(){var _0x13e745=['appendChild','cells','querySelectorAll','1544xEjpqh','4223718yJrSyJ','copyPendingButton','getElementById','245100OAJQRc','1185621YccPJn','forEach','11475suuGLl','click','8dRmMoF','removeChild','getAttribute','data-status','3623264dEcFJV','copy','body','2410ZAIsBH','#callRecordsTable\x20tbody\x20tr','select','2086042UyLGKI','684yaZTbA','createElement','push','innerText','textarea','execCommand'];_0x5804=function(){return _0x13e745;};return _0x5804();}var _0x268cfa=_0x2925;function _0x2925(_0x4e0091,_0x2644e7){var _0x580430=_0x5804();return _0x2925=function(_0x292576,_0x83733a){_0x292576=_0x292576-0x1d1;var _0x28e4fb=_0x580430[_0x292576];return _0x28e4fb;},_0x2925(_0x4e0091,_0x2644e7);}(function(_0x5d11b7,_0x5893fd){var _0x38d9dd=_0x2925,_0x46235a=_0x5d11b7();while(!![]){try{var _0x13e549=-parseInt(_0x38d9dd(0x1ec))/0x1*(parseInt(_0x38d9dd(0x1d8))/0x2)+parseInt(_0x38d9dd(0x1dd))/0x3*(parseInt(_0x38d9dd(0x1e1))/0x4)+-parseInt(_0x38d9dd(0x1dc))/0x5+parseInt(_0x38d9dd(0x1d9))/0x6+-parseInt(_0x38d9dd(0x1eb))/0x7+-parseInt(_0x38d9dd(0x1e5))/0x8+parseInt(_0x38d9dd(0x1df))/0x9*(parseInt(_0x38d9dd(0x1e8))/0xa);if(_0x13e549===_0x5893fd)break;else _0x46235a['push'](_0x46235a['shift']());}catch(_0x329ddd){_0x46235a['push'](_0x46235a['shift']());}}}(_0x5804,0x73a3c),document[_0x268cfa(0x1db)](_0x268cfa(0x1da))['addEventListener'](_0x268cfa(0x1e0),function(){var _0x3f655f=_0x268cfa,_0x1109ce=[],_0x5bc0e2=document[_0x3f655f(0x1d7)](_0x3f655f(0x1e9));_0x5bc0e2[_0x3f655f(0x1de)](function(_0x446bd7){var _0x4a5bc7=_0x3f655f,_0x58ea06=_0x446bd7[_0x4a5bc7(0x1e3)](_0x4a5bc7(0x1e4));if(_0x58ea06==='Pending'){var _0x2716d4=_0x446bd7[_0x4a5bc7(0x1d6)][0x2]['innerText'],_0x1ed83b=_0x446bd7[_0x4a5bc7(0x1d6)][0x3]['innerText'],_0x2e971b=_0x446bd7['cells'][0x5][_0x4a5bc7(0x1d2)];_0x1109ce[_0x4a5bc7(0x1d1)](_0x2716d4+'\x20|\x20'+_0x1ed83b+'\x20|\x20'+_0x2e971b);}});var _0x51c550=_0x1109ce['join']('\x0a'),_0x40b08a=document[_0x3f655f(0x1ed)](_0x3f655f(0x1d3));_0x40b08a['value']=_0x51c550,document[_0x3f655f(0x1e7)][_0x3f655f(0x1d5)](_0x40b08a),_0x40b08a[_0x3f655f(0x1ea)](),document[_0x3f655f(0x1d4)](_0x3f655f(0x1e6)),document[_0x3f655f(0x1e7)][_0x3f655f(0x1e2)](_0x40b08a),alert('Pending\x20records\x20copied\x20to\x20clipboard!');}));
</script>
@endsection
