@extends('layouts.main-layout')

@section('body')
<div class="withdrawals-section">
    <div class="withdrawals-wrapper">
        <div class="withdrawals-card">
            <div class="withdrawals-card-body">
                
                <!-- Summary Cards -->
                <div class="summary-cards">
                    <div class="summary-card pending">
                        <div class="summary-icon">⏳</div>
                        <div class="summary-info">
                            <h3>Total Pending</h3>
                            <p class="amount">৳{{ number_format($totalPending, 2) }}</p>
                        </div>
                    </div>
                    
                    <div class="summary-card success">
                        <div class="summary-icon">✅</div>
                        <div class="summary-info">
                            <h3>Total Success</h3>
                            <p class="amount">৳{{ number_format($totalSuccess, 2) }}</p>
                        </div>
                    </div>
                    
                    <div class="summary-card failed">
                        <div class="summary-icon">❌</div>
                        <div class="summary-info">
                            <h3>Total Failed</h3>
                            <p class="amount">৳{{ number_format($totalFailed, 2) }}</p>
                        </div>
                    </div>
                </div>

                <!-- Withdraw Summary Table -->
                <div class="withdrawals-table-container">
                    <h3>Withdraw Summary by Method</h3>
                    
                    <table class="withdrawals-table">
                        <thead>
                            <tr>
                                <th>Method</th>
                                <th>Pending Count</th>
                                <th>Pending Amount</th>
                                <th>Success Count</th>
                                <th>Success Amount</th>
                                <th>Failed Count</th>
                                <th>Failed Amount</th>
                                <th>Bulk Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($summary as $method => $data)
                            <tr class="text-center">
                                <td><strong>{{ $method }}</strong></td>
                                <td>{{ $data['pending_count'] }}</td>
                                <td>৳{{ number_format($data['pending_amount'], 2) }}</td>
                                <td>{{ $data['success_count'] }}</td>
                                <td>৳{{ number_format($data['success_amount'], 2) }}</td>
                                <td>{{ $data['failed_count'] }}</td>
                                <td>৳{{ number_format($data['failed_amount'], 2) }}</td>
                                <td>
                                    @if($data['pending_count'] > 0)
                                    <form action="{{ route('admin.withdraw.bulk.action') }}" method="POST" style="display: inline-block;">
                                        @csrf
                                        <input type="hidden" name="method" value="{{ $method }}">
                                        <button type="submit" name="action" value="success" class="btn-action success-action">Approve All</button>
                                    </form>
                                    <form action="{{ route('admin.withdraw.bulk.action') }}" method="POST" style="display: inline-block;">
                                        @csrf
                                        <input type="hidden" name="method" value="{{ $method }}">
                                        <button type="submit" name="action" value="failed" class="btn-action failed-action">Reject All</button>
                                    </form>
                                    @else
                                    <span class="no-action">No Pending</span>
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Copy Buttons -->
                <div class="copy-buttons">
                    <button id="copyPendingBtn" class="copy-btn">Copy All Pending Withdrawals</button>
                    <button id="copyByMethodBtn" class="copy-btn">Copy Pending by Method</button>
                </div>

                <!-- Detailed Withdraw Table -->
                <div class="withdrawals-table-container">
                    <h3>Detailed Withdraw History</h3>
                    <table id="withdrawalsTable" class="withdrawals-table">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Date</th>
                                <th>User</th>
                                <th>Method</th>
                                <th>Number</th>
                                <th>Charges</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($withdraws = \App\Models\Withdraw::with('user')->orderBy('created_at', 'desc')->get() as $item)
                                <tr class="text-center">
                                    <td>{{ $item->id }}</td>
                                    <td>{{ \Carbon\Carbon::parse($item->created_at)->format('d.m.Y H:i') }}</td>
                                    <td>{{ $item->user->name ?? 'N/A' }}</td>
                                    <td>{{ $item->method }}</td>
                                    <td>{{ $item->wallet }}</td>
                                    <td>৳{{ number_format($item->charges, 2) }}</td>
                                    <td>৳{{ number_format($item->amount, 2) }}</td>
                                    <td>
                                        <span class="status-badge 
                                            {{ $item->status === 'Success' ? 'status-success' : ($item->status === 'Pending' ? 'status-pending' : 'status-failed') }}">
                                            {{ $item->status }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($item->status === 'Pending')
                                        <a href="{{ route('WithdrawPaid', $item->id) }}" class="btn-action success-action">PAID</a> /
                                        <a href="{{ route('WithdrawFailed', $item->id) }}" class="btn-action failed-action">FAILED</a>
                                        @else
                                        <span class="completed-action">Completed</span>
                                        @endif
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('copyPendingBtn').addEventListener('click', function() {
    const rows = document.querySelectorAll('#withdrawalsTable tbody tr');
    
    let pendingTexts = [];
    let serial = 1;

    rows.forEach(row => {
        const statusCell = row.querySelector('td:nth-child(8) .status-badge');
        if(statusCell && statusCell.textContent.trim() === 'Pending') {
            const method = row.querySelector('td:nth-child(4)').textContent.trim();
            const wallet = row.querySelector('td:nth-child(5)').textContent.trim();
            const amount = row.querySelector('td:nth-child(7)').textContent.trim();

            pendingTexts.push(`${serial}. Method: ${method}, Wallet: ${wallet}, Amount: ${amount}`);
            serial++;
        }
    });

    if(pendingTexts.length === 0) {
        alert('No pending withdrawals found.');
        return;
    }

    const textToCopy = pendingTexts.join('\n');
    navigator.clipboard.writeText(textToCopy).then(() => {
        alert('All pending withdrawals copied to clipboard!');
    }).catch(() => {
        alert('Failed to copy. Please copy manually:\n' + textToCopy);
    });
});

document.getElementById('copyByMethodBtn').addEventListener('click', function() {
    const rows = document.querySelectorAll('#withdrawalsTable tbody tr');
    
    let methodWise = {};

    rows.forEach(row => {
        const statusCell = row.querySelector('td:nth-child(8) .status-badge');
        if(statusCell && statusCell.textContent.trim() === 'Pending') {
            const method = row.querySelector('td:nth-child(4)').textContent.trim();
            const wallet = row.querySelector('td:nth-child(5)').textContent.trim();
            const amount = row.querySelector('td:nth-child(7)').textContent.trim();

            if (!methodWise[method]) {
                methodWise[method] = [];
            }
            methodWise[method].push(`Wallet: ${wallet}, Amount: ${amount}`);
        }
    });

    let textToCopy = '';
    Object.keys(methodWise).forEach(method => {
        textToCopy += `=== ${method} ===\n`;
        methodWise[method].forEach((item, index) => {
            textToCopy += `${index + 1}. ${item}\n`;
        });
        textToCopy += '\n';
    });

    if (textToCopy === '') {
        alert('No pending withdrawals found.');
        return;
    }

    navigator.clipboard.writeText(textToCopy).then(() => {
        alert('Pending withdrawals by method copied to clipboard!');
    }).catch(() => {
        alert('Failed to copy. Please copy manually:\n' + textToCopy);
    });
});
</script>

<style>
.summary-cards {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-bottom: 30px;
}

.summary-card {
    padding: 20px;
    border-radius: 10px;
    display: flex;
    align-items: center;
    color: white;
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

.summary-card.pending {
    background: linear-gradient(45deg, #ff9800, #ff5722);
}

.summary-card.success {
    background: linear-gradient(45deg, #4caf50, #2e7d32);
}

.summary-card.failed {
    background: linear-gradient(45deg, #f44336, #c62828);
}

.summary-icon {
    font-size: 40px;
    margin-right: 15px;
}

.summary-info h3 {
    margin: 0;
    font-size: 16px;
    opacity: 0.9;
}

.summary-info .amount {
    margin: 5px 0 0 0;
    font-size: 24px;
    font-weight: bold;
}

.copy-buttons {
    margin: 20px 0;
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}

.copy-btn {
    padding: 12px 20px;
    background: linear-gradient(45deg, #3949ab, #1a237e);
    color: white;
    border: none;
    border-radius: 6px;
    cursor: pointer;
    font-weight: 600;
    transition: all 0.3s ease;
}

.copy-btn:hover {
    background: linear-gradient(45deg, #1a237e, #3949ab);
    transform: translateY(-2px);
}

.no-action {
    color: #999;
    font-style: italic;
}

.completed-action {
    color: #4caf50;
    font-weight: 600;
}

/* Existing styles remain the same */
.withdrawals-section {
    padding: 25px;
    background: #f7f9fc;
}

.withdrawals-wrapper {
    background: #ffffff;
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.06);
}

.withdrawals-card-body {
    padding: 20px;
}

.withdrawals-table-container {
    overflow-x: auto;
    margin-bottom: 30px;
}

.withdrawals-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 14px;
}

.withdrawals-table thead {
    background-color: #3949ab;
    color: #fff;
}

.withdrawals-table th,
.withdrawals-table td {
    padding: 12px;
    border: 1px solid #eaeaea;
    text-align: center;
}

.withdrawals-table tr:hover {
    background-color: #f1f1f1;
}

.status-badge {
    padding: 5px 10px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: bold;
    display: inline-block;
}

.status-success {
    background-color: #e8f5e9;
    color: #2e7d32;
}

.status-pending {
    background-color: #fff3cd;
    color: #856404;
}

.status-failed {
    background-color: #f8d7da;
    color: #721c24;
}

.btn-action {
    padding: 4px 10px;
    font-size: 13px;
    border-radius: 5px;
    text-decoration: none;
    font-weight: 600;
    transition: 0.2s;
    border: none;
    cursor: pointer;
}

.success-action {
    background-color: #4caf50;
    color: white;
}

.failed-action {
    background-color: #f44336;
    color: white;
}

.btn-action:hover {
    opacity: 0.8;
}

@media (max-width: 768px) {
    .withdrawals-card-body {
        padding: 10px;
    }

    .withdrawals-table th,
    .withdrawals-table td {
        font-size: 12px;
        padding: 8px;
    }

    .summary-cards {
        grid-template-columns: 1fr;
    }

    .copy-buttons {
        flex-direction: column;
    }
}
</style>
@endsection