@extends('layouts.main-layout')


@section('body')


            <div class="custom-admin-row">
    <div class="custom-admin-col">
        <div class="custom-card-box">
            <div class="custom-card-body">
                <div class="table-responsive">
                    <table id="userManagementTable" class="custom-table">
                        <thead class="custom-table-head">
                            <tr>
                                <th>#ID</th>
                                <th>User Name</th>
                                <th>Phone</th>
                                <th>Email</th>
                                <th>Balance</th>
                                <th>Status</th>
                                <th>Deactive</th>
                                <th>Join Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody class="custom-table-body">
                            @foreach($data as $item)
                                <tr>
                                    <td>{{ $item->id }}</td>
                                    <td>{{ $item->fname }} {{ $item->lname }}</td>
                                    <td>{{ $item->phone }}</td>
                                    <td>{{ $item->email }}</td>
                                    <td>{{ $item->balance }} BDT</td>
                                    <td>
                                        <span class="status-badge {{ $item->user_active == 1 ? 'status-active' : 'status-inactive' }}">
                                            {{ $item->user_active == 1 ? 'Active' : 'Inactive' }}
                                        </span>
                                    </td>
                                    <td>{{ $item->deactive }}</td>
                                    <td>{{ $item->created_at->format('M d, Y') }}</td>
                                    <td>
                                        <a href="{{ route('ActiveUser', $item->id) }}" class="action-btn action-activate">Activate</a> /
                                        <a href="{{ route('DectiveUser', $item->id) }}" class="action-btn action-deactivate">Deactivate</a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div> <!-- .table-responsive -->
            </div> <!-- .custom-card-body -->
        </div> <!-- .custom-card-box -->
    </div> <!-- .custom-admin-col -->
</div> <!-- .custom-admin-row -->
<style>
    .custom-admin-row {
    margin: 20px 0;
}

.custom-admin-col {
    width: 100%;
}

.custom-card-box {
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 6px 15px rgba(0, 0, 0, 0.05);
    overflow: hidden;
    transition: all 0.3s ease-in-out;
}

.custom-card-body {
    padding: 25px;
}

.custom-table {
    width: 100%;
    border-collapse: collapse;
}

.custom-table thead {
    background: linear-gradient(to right, #ff9900, #ffc107);
    color: #fff;
    text-align: left;
}

.custom-table th,
.custom-table td {
    padding: 14px 16px;
    border-bottom: 1px solid #ddd;
    font-size: 14px;
}

.custom-table tbody tr:hover {
    background-color: #fffbea;
}

.status-badge {
    padding: 5px 12px;
    border-radius: 50px;
    font-weight: 500;
    font-size: 13px;
    display: inline-block;
}

.status-active {
    background-color: #e0f7e9;
    color: #1e7e34;
}

.status-inactive {
    background-color: #fdecea;
    color: #c82333;
}

.action-btn {
    padding: 4px 10px;
    border-radius: 5px;
    font-size: 13px;
    text-decoration: none;
    font-weight: 600;
}

.action-activate {
    background-color: #28a745;
    color: #fff;
}

.action-deactivate {
    background-color: #dc3545;
    color: #fff;
}

@media screen and (max-width: 768px) {
    .custom-card-body {
        padding: 15px;
    }

    .custom-table th, .custom-table td {
        padding: 10px;
    }
}

</style>

@endsection
