@extends('layouts.main-layout')


@section('body')

    <div class="gem-settings-wrapper">
        <div class="gem-settings-card">
            <form action="{{ route('systemSettingsPost') }}" method="POST">
                @csrf
                <div class="gem-settings-body">
                    @foreach ($settings as $key => $value)
                        <div class="gem-settings-field">
                            <label class="gem-settings-label" for="gem-setting-{{ $key }}">
                                {{ ucwords(str_replace('_', ' ', $key)) }}
                            </label>
                            <input
                                type="text"
                                class="gem-settings-input"
                                name="settings[{{ $key }}]"
                                id="gem-setting-{{ $key }}"
                                value="{{ $value }}"
                            >
                        </div>
                    @endforeach
                </div>
                <div class="gem-settings-footer">
                    <button type="submit" class="gem-settings-submit-btn">Save Settings</button>
                </div>
            </form>
        </div>
    </div>
<style>
/* Base styles (ensure Inter font is linked in your main-layout.blade.php) */
body {
    font-family: 'Inter', sans-serif;
    background-color: #f5f7fa; /* Lighter, subtle background */
    color: #4a5568; /* Darker grey for text */
    -webkit-font-smoothing: antialiased;
    -moz-osx-font-smoothing: grayscale;
}

/* --- Gem Settings Wrapper --- */
.gem-settings-wrapper {
    padding: 20px; /* Reduced padding */
    display: flex; /* Use flexbox for centering */
    justify-content: center;
    align-items: flex-start; /* Align to top */
    min-height: calc(100vh - 100px); /* Adjust based on header/footer height */
}

.gem-settings-card {
    background: #ffffff;
    border-radius: 10px; /* Slightly smaller radius */
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08); /* More prominent shadow */
    max-width: 100%; /* Reduced max-width for a more compact form */
    width: 100%; /* Ensure it fills available space up to max-width */
    border: 1px solid #e2e8f0; /* Subtle border */
    overflow: hidden; /* Ensures border-radius applies cleanly */
}

.gem-settings-body {
    padding: 25px 30px; /* Adjusted padding */
}

.gem-settings-field {
    margin-bottom: 18px; /* Slightly reduced margin */
}

.gem-settings-label {
    display: block;
    font-weight: 600;
    margin-bottom: 6px; /* Reduced margin */
    color: #2d3748; /* Darker label text */
    font-size: 0.9rem; /* Slightly smaller font size */
}

.gem-settings-input {
    width: 100%;
    padding: 9px 12px; /* Reduced padding for smaller input */
    font-size: 0.9rem; /* Smaller font size */
    border: 1px solid #cbd5e0; /* Softer border color */
    border-radius: 6px; /* Smaller border-radius */
    background-color: #fcfdfe; /* Very light background */
    transition: border-color 0.2s ease, box-shadow 0.2s ease;
    -webkit-appearance: none; /* For consistent styling on iOS */
    -moz-appearance: none; /* For consistent styling on Firefox */
    appearance: none;
}

.gem-settings-input:focus {
    border-color: #4299e1; /* Blue focus color */
    outline: none;
    background-color: #ffffff;
    box-shadow: 0 0 0 3px rgba(66, 153, 225, 0.2); /* Soft blue focus ring */
}

.gem-settings-footer {
    padding: 15px 30px; /* Consistent horizontal padding */
    border-top: 1px solid #edf2f7; /* Lighter border */
    text-align: right;
    background-color: #f7fafc; /* Subtle background for footer */
}

.gem-settings-submit-btn {
    padding: 9px 20px; /* Reduced padding */
    background-color: #48bb78; /* Vibrant green */
    color: white;
    font-weight: 600;
    border: none;
    border-radius: 6px; /* Consistent border-radius */
    cursor: pointer;
    transition: background-color 0.2s ease, transform 0.1s ease;
    font-size: 0.9rem; /* Smaller font size */
}

.gem-settings-submit-btn:hover {
    background-color: #38a169; /* Darker green on hover */
    transform: translateY(-1px); /* Subtle lift effect */
    box-shadow: 0 2px 6px rgba(72, 187, 120, 0.3);
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .gem-settings-wrapper {
        padding: 15px;
    }
    .gem-settings-card {
        border-radius: 8px;
    }
    .gem-settings-body {
        padding: 20px 25px;
    }
    .gem-settings-footer {
        padding: 12px 25px;
    }
    .gem-settings-submit-btn {
        width: 100%; /* Full width button on smaller screens */
        padding: 10px;
    }
}

</style>

@endsection