<!-- resources/views/admin/sentences.blade.php -->

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Admin - Add Sentences</title>

    <style>
        /* Reset & base */
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        body {
            background: #f4f7fc;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            padding: 20px;
        }
        main {
            background: #fff;
            padding: 40px 50px;
            border-radius: 12px;
            box-shadow: 0 8px 20px rgba(0,0,0,0.1);
            width: 100%;
            max-width: 480px;
            text-align: center;
        }
        h1 {
            margin-bottom: 24px;
            font-weight: 700;
            font-size: 1.9rem;
            color: #333;
        }
        p.success-message {
            background-color: #d4edda;
            color: #155724;
            padding: 12px 20px;
            border-radius: 8px;
            margin-bottom: 24px;
            font-weight: 600;
            font-size: 1rem;
            border: 1px solid #c3e6cb;
        }
        form {
            display: flex;
            flex-direction: column;
            gap: 18px;
        }
        label {
            font-size: 1.1rem;
            color: #555;
            text-align: left;
        }
        input[type="number"] {
            padding: 12px 15px;
            font-size: 1rem;
            border: 2px solid #ccc;
            border-radius: 8px;
            transition: border-color 0.3s ease;
        }
        input[type="number"]:focus {
            outline: none;
            border-color: #4a90e2;
            box-shadow: 0 0 8px rgba(74, 144, 226, 0.3);
        }
        button {
            background: linear-gradient(135deg, #4a90e2, #357ABD);
            color: #fff;
            font-size: 1.1rem;
            font-weight: 700;
            padding: 14px;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            box-shadow: 0 6px 12px rgba(53, 122, 189, 0.4);
            transition: background 0.3s ease, box-shadow 0.3s ease;
        }
        button:hover {
            background: linear-gradient(135deg, #357ABD, #4a90e2);
            box-shadow: 0 8px 18px rgba(53, 122, 189, 0.6);
        }
        button:active {
            transform: translateY(2px);
            box-shadow: 0 4px 8px rgba(53, 122, 189, 0.5);
        }
    </style>
</head>
<body>
    <main>
        <p>Total sentences: {{ $totalSentences }}</p>
        <h1>Add Sentences</h1>

        @if(session('success'))
            <p class="success-message">{{ session('success') }}</p>
        @endif

        <form method="POST" action="{{ route('sentences.store') }}">
            @csrf
            <label for="amount">How many sentences to generate?</label>
            <input id="amount" type="number" name="amount" min="1" max="100" required />
            <button type="submit">Generate Sentences</button>
        </form>
    </main>
</body>
</html>

