@extends('layouts.main-layout')

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Profile</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Profile</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('body')
    <div class="row">
        <div class="col-md-3">

            <!-- Profile Image -->
            <div class="card card-primary card-outline">
                <div class="card-body box-profile">
                    <div class="text-center">
                        <img class="profile-user-img img-fluid img-circle"
                             src="{{asset('dist/img/user4-128x128.jpg')}}"
                             alt="User profile picture">
                    </div>

                    <h3 class="profile-username text-center">{{ $profile['full_name'] }}</h3>

                    <p class="text-muted text-center">{{ $profile['work_post'] }}</p>

                    <a href="#" class="btn btn-primary btn-block" data-toggle="tooltip" data-placement="top" title="" data-original-title="Join Date"><b>{{ $profile['join_date'] }}</b></a>
                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->

            <!-- About Me Box -->
            <div class="card card-primary">
                <div class="card-header">
                    <h3 class="card-title">About Me</h3>
                </div>
                <!-- /.card-header -->
                <div class="card-body">

                    <strong><i class="fas fa-piggy-bank mr-1"></i> Salary</strong>

                    <p class="text-muted">৳{{ $profile['salary'] }} BDT per month</p>

                    <hr>

                    <strong><i class="fas fa-book mr-1"></i> Education</strong>

                    <p class="text-muted">
                        {{ $profile['education'] }}
                    </p>

                    <hr>

                    <strong><i class="fas fa-pencil-alt mr-1"></i> Skills</strong>

                    <p class="text-muted">
                        {{ $profile['skills'] }}
                    </p>

                </div>
                <!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.col -->
        <div class="col-md-9">
            <div class="card">
                <div class="card-header p-2">
                    <ul class="nav nav-pills">
                        <li class="nav-item"><a class="nav-link active" href="#settlement" data-toggle="tab">Settlement History</a></li>
                        <li class="nav-item"><a class="nav-link" href="#settings" data-toggle="tab">Settings</a></li>
                    </ul>
                </div><!-- /.card-header -->
                <div class="card-body">
                    <div class="tab-content">
                        <!-- /.tab-pane -->
                        <div class="active tab-pane" id="settlement">
                            <!-- /.card-header -->
                                <table id="settlementTable" class="table table-bordered table-striped">
                                    <thead>
                                    <tr>
                                        <th data-sortable="true">ID</th>
                                        <th data-sortable="false">Amount</th>
                                        <th data-sortable="false">Note</th>
                                        <th data-sortable="false">Status</th>
                                        <th data-sortable="false">Date</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr>
                                        <td>1000</td>
                                        <td>5000 /=</td>
                                        <td>Salary paid on Bank</td>
                                        <td>Paid</td>
                                        <td>11-06-2023</td>
                                    </tr>
                                    </tbody>
                                </table>
                            <!-- /.card-body -->
                        </div>
                        <!-- /.tab-pane -->

                        <div class="tab-pane" id="settings">
                            <form class="form-horizontal" action="{{route('profilePost')}}" method="post">
                                <div class="form-group row">
                                    <label for="fullName" class="col-sm-2 col-form-label">Full Name</label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="fullName" placeholder="Full Name" name="full_name" value="{{ $profile['full_name'] }}">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="inputEmail" class="col-sm-2 col-form-label">Email</label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="inputEmail" placeholder="Email address" name="email_address" value="{{ $profile['contact_mail'] }}">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="inputPhone" class="col-sm-2 col-form-label">Phone Number</label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="inputPhone" placeholder="Phone Number" name="phone_number" value="{{ $profile['phone_number'] }}">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="inputAddress" class="col-sm-2 col-form-label">Address</label>
                                    <div class="col-sm-10">
                                        <textarea class="form-control" id="inputAddress" placeholder="Address" name="address">{{ $profile['address'] }}</textarea>
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="inputCity" class="col-sm-2 col-form-label">City</label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="inputCity" placeholder="City" name="city" value="{{ $profile['city'] }}">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="inputState" class="col-sm-2 col-form-label">State</label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="inputState" placeholder="State" name="state" value="{{ $profile['state'] }}">
                                    </div>
                                </div>
                                <div class="form-group row">
                                    <label for="inputPostcode" class="col-sm-2 col-form-label">Postcode</label>
                                    <div class="col-sm-10">
                                        <input type="text" class="form-control" id="inputPostcode" placeholder="Postcode" name="postcode" value="{{ $profile['postcode'] }}">
                                    </div>
                                </div>

                                <div class="form-group row">
                                    <div class="offset-sm-2 col-sm-10">
                                        <button type="submit" class="btn btn-danger">Submit</button>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- /.tab-pane -->
                    </div>
                    <!-- /.tab-content -->
                </div><!-- /.card-body -->
            </div>
            <!-- /.card -->
        </div>
        <!-- /.col -->
    </div>
@endsection
