@extends('layouts.main-layout')


@section('body')


           <div class="payment-history-section">
    <div class="payment-history-wrapper">
        <div class="payment-card">
            <div class="payment-card-body">
                <div class="payment-table-responsive">
                    <table id="userPaymentTable" class="payment-table">
                        <thead class="payment-table-head">
                            <tr>
                                <th>ID</th>
                                <th>Date</th>
                                <th>Method</th>
                                <th>Number</th>
                                <th>Transaction ID</th>
                                <th>Amount</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody class="payment-table-body">
                            @foreach($data as $item)
                                <tr class="text-center">
                                    <td>{{ $item->id }}</td>
                                    <td>{{ \Carbon\Carbon::parse($item->created_at)->format('d.m.Y') }}</td>
                                    <td>{{ $item->method }}</td>
                                    <td>{{ $item->number }}</td>
                                    <td>{{ $item->trxid }}</td>
                                    <td>{{ $item->amount }}</td>
                                    <td>
                                        <span class="status-badge 
                                            {{ $item->status == 'Success' ? 'status-success' : ($item->status == 'Pending' ? 'status-pending' : 'status-failed') }}">
                                            {{ $item->status }}
                                        </span>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div> <!-- .payment-table-responsive -->
            </div> <!-- .payment-card-body -->
        </div> <!-- .payment-card -->
    </div> <!-- .payment-history-wrapper -->
</div> <!-- .payment-history-section -->
<style>
    .payment-history-section {
    margin-top: 30px;
}

.payment-history-wrapper {
    width: 100%;
    background: #f9f9f9;
    padding: 20px;
    border-radius: 12px;
    box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
}

.payment-card {
    background-color: #fff;
    border-radius: 10px;
    overflow: hidden;
}

.payment-card-body {
    padding: 25px;
}

.payment-table-responsive {
    overflow-x: auto;
}

.payment-table {
    width: 100%;
    border-collapse: collapse;
}

.payment-table thead {
    background-color: #4a90e2;
    color: white;
}

.payment-table th,
.payment-table td {
    padding: 12px 16px;
    border: 1px solid #eee;
    font-size: 14px;
}

.payment-table tbody tr:hover {
    background-color: #f1f1f1;
}

.status-badge {
    padding: 5px 12px;
    font-size: 13px;
    font-weight: 600;
    border-radius: 50px;
    display: inline-block;
    text-transform: uppercase;
}

.status-success {
    background-color: #e8f5e9;
    color: #2e7d32;
}

.status-pending {
    background-color: #fff3cd;
    color: #856404;
}

.status-failed {
    background-color: #f8d7da;
    color: #721c24;
}

/* Responsive */
@media (max-width: 768px) {
    .payment-card-body {
        padding: 15px;
    }

    .payment-table th,
    .payment-table td {
        font-size: 13px;
        padding: 10px;
    }
}


</style>

@endsection
