@extends('layouts.main-layout')

@section('body')
<div class="container-fluid">
    <div class="row">
        <div class="col-lg-12 mx-auto">
            
            <!-- Create New Lottery Card -->
            <div class="card card-glassmorphism mb-4">
                <div class="card-header bg-gradient-success text-white rounded-top">
                    <h4 class="mb-0"><i class="fas fa-plus-circle me-2"></i>Create New Lottery</h4>
                </div>
                <div class="card-body">
                    <form action="{{ route('createNewLottery') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Lottery Date</label>
                                <input type="date" class="form-control rounded-10" name="lottery_date" 
                                       value="{{ old('lottery_date', now()->format('Y-m-d')) }}" required>
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label">Join Amount (৳)</label>
                                <input type="number" step="0.01" class="form-control rounded-10" 
                                       name="join_amount" value="{{ old('join_amount', 10) }}" required>
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label">1st Prize (৳)</label>
                                <input type="number" step="0.01" class="form-control rounded-10" 
                                       name="first_prize" value="{{ old('first_prize', 100) }}" required>
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label">2nd Prize (৳)</label>
                                <input type="number" step="0.01" class="form-control rounded-10" 
                                       name="second_prize" value="{{ old('second_prize', 50) }}" required>
                            </div>
                            <div class="col-md-2 mb-3">
                                <label class="form-label">3rd Prize (৳)</label>
                                <input type="number" step="0.01" class="form-control rounded-10" 
                                       name="third_prize" value="{{ old('third_prize', 25) }}" required>
                            </div>
                            <div class="col-md-1 mb-3 d-flex align-items-end">
                                <button type="submit" class="btn btn-success w-100">
                                    <i class="fas fa-plus"></i> Create
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Today's Lottery Card -->
            <div class="card card-glassmorphism mb-4">
                <div class="card-header bg-gradient-primary text-white rounded-top">
                    <h4 class="mb-0"><i class="fas fa-ticket-alt me-2"></i>Today's Lottery - {{ date('F d, Y') }}</h4>
                </div>
                <div class="card-body">
                    <!-- Current Lottery Info -->
                    <div class="row mb-4">
                        <div class="col-md-3 mb-3">
                            <div class="card bg-primary text-white rounded-15">
                                <div class="card-body text-center">
                                    <h6><i class="fas fa-users me-2"></i>Total Participants</h6>
                                    <h4 class="mb-0">{{ $todayLottery->total_participants }}</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card bg-info text-white rounded-15">
                                <div class="card-body text-center">
                                    <h6><i class="fas fa-money-bill-wave me-2"></i>Entry Fee</h6>
                                    <h4 class="mb-0">{{ $todayLottery->join_amount }} ৳</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card bg-warning text-white rounded-15">
                                <div class="card-body text-center">
                                    <h6><i class="fas fa-trophy me-2"></i>1st Prize</h6>
                                    <h4 class="mb-0">{{ $todayLottery->first_prize }} ৳</h4>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3 mb-3">
                            <div class="card bg-success text-white rounded-15">
                                <div class="card-body text-center">
                                    <h6><i class="fas fa-trophy me-2"></i>Status</h6>
                                    <h4 class="mb-0">
                                        @if($todayLottery->is_completed)
                                            <span class="badge bg-success">Completed</span>
                                        @else
                                            <span class="badge bg-warning">Running</span>
                                        @endif
                                    </h4>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Lottery Settings Form -->
                    <form action="{{ route('lotterySettingsPost') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Join Amount (৳)</label>
                                <input type="number" step="0.01" class="form-control rounded-10" 
                                       name="join_amount" value="{{ $todayLottery->join_amount }}" required>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">1st Prize (৳)</label>
                                <input type="number" step="0.01" class="form-control rounded-10" 
                                       name="first_prize" value="{{ $todayLottery->first_prize }}" required>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">2nd Prize (৳)</label>
                                <input type="number" step="0.01" class="form-control rounded-10" 
                                       name="second_prize" value="{{ $todayLottery->second_prize }}" required>
                            </div>
                            <div class="col-md-3 mb-3">
                                <label class="form-label">3rd Prize (৳)</label>
                                <input type="number" step="0.01" class="form-control rounded-10" 
                                       name="third_prize" value="{{ $todayLottery->third_prize }}" required>
                            </div>
                        </div>

                        <div class="text-center">
                            <button type="submit" class="btn btn-primary btn-lg rounded-pill px-4">
                                <i class="fas fa-save me-2"></i>Update Settings
                            </button>
                        </div>
                    </form>

                    <!-- Lottery Actions -->
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card border-0 rounded-15 bg-light">
                                <div class="card-body text-center py-4">
                                    <h5 class="mb-3">Lottery Actions</h5>
                                    
                                    @if(!$todayLottery->is_completed)
                                        @if($todayLottery->total_participants >= 3)
                                            <a href="{{ route('runLotteryDraw') }}" 
                                               class="btn btn-success btn-lg rounded-pill px-4 py-2"
                                               onclick="return confirm('Are you sure you want to run the lottery draw? This will select 3 random winners and cannot be undone!')">
                                                🎲 Run Lottery Draw Now
                                            </a>
                                            <p class="text-muted mt-3">
                                                Click to randomly select 3 winners from {{ $todayLottery->total_participants }} participants. 
                                                Winners will be paid automatically.
                                            </p>
                                        @else
                                            <button class="btn btn-secondary btn-lg rounded-pill px-4 py-2" disabled>
                                                Need at least 3 participants
                                            </button>
                                            <p class="text-danger mt-2">
                                                Currently have {{ $todayLottery->total_participants }} participants. 
                                                Need {{ 3 - $todayLottery->total_participants }} more to run the draw.
                                            </p>
                                        @endif
                                    @else
                                        <div class="alert alert-success">
                                            <h5>✅ Lottery Completed Today</h5>
                                            <p class="mb-0">Winners have been selected and paid automatically.</p>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Current Participants -->
                    @if($todayLottery->participants->count() > 0)
                    <div class="row mt-4">
                        <div class="col-12">
                            <div class="card border-0 rounded-15">
                                <div class="card-header bg-gradient-info text-white rounded-top">
                                    <h5 class="mb-0">Current Participants ({{ $todayLottery->total_participants }})</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-striped table-hover">
                                            <thead class="table-dark">
                                                <tr>
                                                    <th>#</th>
                                                    <th>User Name</th>
                                                    <th>Ticket Number</th>
                                                    <th>Join Time</th>
                                                    <th>Status</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($todayLottery->participants as $index => $participant)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>
                                                        <div class="d-flex align-items-center">
                                                            @if($participant->user->profile_image)
                                                                <img src="{{ asset('uploads/profile_images/' . $participant->user->profile_image) }}" 
                                                                     class="rounded-circle me-2" width="30" height="30" alt="User">
                                                            @else
                                                                <div class="bg-primary rounded-circle me-2 d-flex align-items-center justify-content-center" 
                                                                     style="width: 30px; height: 30px;">
                                                                    <span class="text-white fw-bold">{{ substr($participant->user->fname, 0, 1) }}</span>
                                                                </div>
                                                            @endif
                                                            {{ $participant->user->fname }}
                                                        </div>
                                                    </td>
                                                    <td><code class="bg-light p-1 rounded">{{ $participant->ticket_number }}</code></td>
                                                    <td>{{ $participant->created_at->format('h:i A') }}</td>
                                                    <td>
                                                        @if($todayLottery->is_completed)
                                                            @if($participant->has_won)
                                                                <span class="badge bg-success">
                                                                    Winner ({{ ucfirst($participant->prize_type) }})
                                                                </span>
                                                            @else
                                                                <span class="badge bg-secondary">Not Won</span>
                                                            @endif
                                                        @else
                                                            <span class="badge bg-primary">Participating</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <!-- All Lotteries List -->
            <div class="card card-glassmorphism">
                <div class="card-header bg-gradient-secondary text-white rounded-top">
                    <h4 class="mb-0"><i class="fas fa-list me-2"></i>All Lotteries</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>Date</th>
                                    <th>Entry Fee</th>
                                    <th>1st Prize</th>
                                    <th>2nd Prize</th>
                                    <th>3rd Prize</th>
                                    <th>Participants</th>
                                    <th>Status</th>
                                    <th>Winners</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($allLotteries as $lottery)
                                <tr>
                                    <td>
                                        <strong>{{ \Carbon\Carbon::parse($lottery->lottery_date)->format('M d, Y') }}</strong>
                                        @if($lottery->lottery_date == today()->toDateString())
                                            <span class="badge bg-primary">Today</span>
                                        @endif
                                    </td>
                                    <td>{{ $lottery->join_amount }} ৳</td>
                                    <td>{{ $lottery->first_prize }} ৳</td>
                                    <td>{{ $lottery->second_prize }} ৳</td>
                                    <td>{{ $lottery->third_prize }} ৳</td>
                                    <td>
                                        <span class="badge bg-info">{{ $lottery->total_participants }}</span>
                                    </td>
                                    <td>
                                        @if($lottery->is_completed)
                                            <span class="badge bg-success">Completed</span>
                                        @else
                                            <span class="badge bg-warning">Running</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($lottery->is_completed && $lottery->winners)
                                            @foreach($lottery->winners as $winner)
                                                <small class="d-block">
                                                    {{ $winner['user_name'] }} ({{ $winner['prize_type'] }})
                                                </small>
                                            @endforeach
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($lottery->is_completed)
                                            <button class="btn btn-danger btn-sm" 
                                                    onclick="deleteLottery({{ $lottery->id }})"
                                                    title="Delete Lottery">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function deleteLottery(lotteryId) {
    if (confirm('Are you sure you want to delete this lottery? This action cannot be undone!')) {
        window.location.href = "{{ url('admin/delete-lottery') }}/" + lotteryId;
    }
}
</script>

<style>
.card-glassmorphism {
    background: rgba(255, 255, 255, 0.95);
    backdrop-filter: blur(10px);
    border-radius: 20px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
}

.rounded-15 {
    border-radius: 15px;
}

.rounded-10 {
    border-radius: 10px;
}

.bg-gradient-primary {
    background: linear-gradient(135deg, #007bff 0%, #0056b3 100%) !important;
}

.bg-gradient-success {
    background: linear-gradient(135deg, #28a745 0%, #1e7e34 100%) !important;
}

.bg-gradient-secondary {
    background: linear-gradient(135deg, #6c757d 0%, #495057 100%) !important;
}

.bg-gradient-info {
    background: linear-gradient(135deg, #17a2b8 0%, #138496 100%) !important;
}

.btn-lg {
    font-weight: bold;
    transition: all 0.3s ease;
}

.btn-lg:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
}
</style>
@endsection