@extends('layouts.main-layout')

@section('content-header')
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Manage Nameserver</h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{route('dashboard')}}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Manage Nameserver</li>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
@endsection

@section('body')

    <div class="col-md-12">
        <div class="card">
            <form action="{{ route('DomainNs', $domainid) }}" method="post">
                @csrf
                <div class="card-body">
                    <div class="mb-3">
                        <label for="ns1Input" class="form-label">Nameserver 1</label>
                        <input name="nameserver1" type="text" class="form-control" id="ns1Input" value="{{ isset($responseData['ns1'])?$responseData['ns1']:"" }}"
                               placeholder="Nameserver 1">
                    </div>
                    <div class="mb-3">
                        <label for="ns2Input" class="form-label">Nameserver 2</label>
                        <input name="nameserver2" type="text" class="form-control" id="ns2Input" value="{{ isset($responseData['ns2'])?$responseData['ns2']:"" }}"
                               placeholder="Nameserver 2">
                    </div>
                    <div class="mb-3">
                        <label for="ns3Input" class="form-label">Nameserver 3</label>
                        <input name="nameserver3" type="text" class="form-control" id="ns3Input" value="{{ isset($responseData['ns3'])?$responseData['ns3']:"" }}"
                               placeholder="Nameserver 3">
                    </div>
                    <div class="mb-3">
                        <label for="ns4Input" class="form-label">Nameserver 4</label>
                        <input name="nameserver4" type="text" class="form-control" id="ns4Input" value="{{ isset($responseData['ns4'])?$responseData['ns4']:"" }}"
                               placeholder="Nameserver 4">
                    </div>
                </div>

                <div class="card-footer">
                    <button class="btn btn-success">Submit</button>
                </div>
            </form>
        </div>
    </div>


@endsection
