@extends('layouts.main-layout')

@section('body')
<div class="container-fluid">
    <!-- Page Header -->
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-cog text-primary"></i>
            Channel Order Settings
        </h1>
        <a href="{{ route('admin.channel.orders') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back to Orders
        </a>
    </div>

    <!-- Bot Information -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-left-info shadow">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h5 class="card-title text-info">
                                <i class="fab fa-telegram-plane"></i>
                                Telegram Bot Information
                            </h5>
                            <p class="card-text">
                                Users must add this bot as admin to their Telegram channels for order verification.
                                The bot will check if the user is admin of the channel and if the bot itself has admin rights.
                            </p>
                        </div>
                        <div class="col-md-4 text-right">
                            <a href="https://t.me/ChatID_SB_Robot" target="_blank" class="btn btn-info btn-lg">
                                <i class="fab fa-telegram-plane"></i>
                                @ChatID_SB_Robot
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Current Settings Overview -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-chart-bar"></i>
                        Current Settings Overview
                    </h6>
                </div>
                <div class="card-body">
                    <div class="row text-center">
                        <div class="col-md-2 col-6 mb-3">
                            <div class="border rounded p-3">
                                <div class="h4 font-weight-bold text-primary">
                                    {{ $settings['min_channel_members']->value ?? '100' }}
                                </div>
                                <small class="text-muted">Min Members</small>
                            </div>
                        </div>
                        <div class="col-md-2 col-6 mb-3">
                            <div class="border rounded p-3">
                                <div class="h4 font-weight-bold text-primary">
                                    {{ $settings['max_channel_members']->value ?? '10000' }}
                                </div>
                                <small class="text-muted">Max Members</small>
                            </div>
                        </div>
                        <div class="col-md-2 col-6 mb-3">
                            <div class="border rounded p-3">
                                <div class="h4 font-weight-bold text-success">
                                    ৳{{ $settings['cost_per_member']->value ?? '0.50' }}
                                </div>
                                <small class="text-muted">Cost/Member</small>
                            </div>
                        </div>
                        <div class="col-md-2 col-6 mb-3">
                            <div class="border rounded p-3">
                                <div class="h4 font-weight-bold text-success">
                                    ৳{{ $settings['min_order_amount']->value ?? '50' }}
                                </div>
                                <small class="text-muted">Min Order</small>
                            </div>
                        </div>
                        <div class="col-md-2 col-6 mb-3">
                            <div class="border rounded p-3">
                                <div class="h4 font-weight-bold text-info">
                                    {{ $settings['max_orders_per_day']->value ?? '5' }}
                                </div>
                                <small class="text-muted">Max Orders/Day</small>
                            </div>
                        </div>
                        <div class="col-md-2 col-6 mb-3">
                            <div class="border rounded p-3">
                                <div class="h4 font-weight-bold text-danger">
                                    {{ \App\Models\ChannelOrder::count() }}
                                </div>
                                <small class="text-muted">Total Orders</small>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Settings Form -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header bg-success text-white">
                    <h6 class="m-0 font-weight-bold">
                        <i class="fas fa-edit"></i>
                        Update Channel Settings
                    </h6>
                </div>
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.channel.settings.update') }}" id="settingsForm">
                        @csrf

                        <!-- Member Settings -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="text-primary mb-3">
                                    <i class="fas fa-users"></i>
                                    Member Settings
                                </h5>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="min_channel_members" class="font-weight-bold">
                                        Minimum Channel Members *
                                    </label>
                                    <input type="number" 
                                           id="min_channel_members" 
                                           name="min_channel_members" 
                                           class="form-control" 
                                           value="{{ $settings['min_channel_members']->value ?? '100' }}" 
                                           min="1"
                                           required>
                                    <small class="form-text text-muted">
                                        Minimum number of members users can order per channel
                                    </small>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="max_channel_members" class="font-weight-bold">
                                        Maximum Channel Members *
                                    </label>
                                    <input type="number" 
                                           id="max_channel_members" 
                                           name="max_channel_members" 
                                           class="form-control" 
                                           value="{{ $settings['max_channel_members']->value ?? '10000' }}" 
                                           min="1"
                                           required>
                                    <small class="form-text text-muted">
                                        Maximum number of members users can order per channel
                                    </small>
                                </div>
                            </div>
                        </div>

                        <!-- Pricing Settings -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="text-success mb-3">
                                    <i class="fas fa-money-bill-wave"></i>
                                    Pricing Settings
                                </h5>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="cost_per_member" class="font-weight-bold">
                                        Cost Per Member (৳) *
                                    </label>
                                    <input type="number" 
                                           id="cost_per_member" 
                                           name="cost_per_member" 
                                           class="form-control" 
                                           value="{{ $settings['cost_per_member']->value ?? '0.50' }}" 
                                           min="0.01"
                                           step="0.01"
                                           required>
                                    <small class="form-text text-muted">
                                        Cost per member in Bangladeshi Taka
                                    </small>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="min_order_amount" class="font-weight-bold">
                                        Minimum Order Amount (৳) *
                                    </label>
                                    <input type="number" 
                                           id="min_order_amount" 
                                           name="min_order_amount" 
                                           class="form-control" 
                                           value="{{ $settings['min_order_amount']->value ?? '50' }}" 
                                           min="1"
                                           step="0.01"
                                           required>
                                    <small class="form-text text-muted">
                                        Minimum total amount required for an order
                                    </small>
                                </div>
                            </div>
                        </div>

                        <!-- Order Limits -->
                        <div class="row mb-4">
                            <div class="col-12">
                                <h5 class="text-info mb-3">
                                    <i class="fas fa-tachometer-alt"></i>
                                    Order Limits
                                </h5>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="max_orders_per_day" class="font-weight-bold">
                                        Maximum Orders Per Day *
                                    </label>
                                    <input type="number" 
                                           id="max_orders_per_day" 
                                           name="max_orders_per_day" 
                                           class="form-control" 
                                           value="{{ $settings['max_orders_per_day']->value ?? '5' }}" 
                                           min="1"
                                           required>
                                    <small class="form-text text-muted">
                                        Maximum number of orders a user can place per day
                                    </small>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="form-group">
                                    <label class="font-weight-bold">Current Revenue</label>
                                    <div class="alert alert-success">
                                        <h4 class="mb-0">৳{{ number_format(\App\Models\ChannelOrder::sum('total_cost'), 2) }}</h4>
                                        <small>Total revenue from channel orders</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Form Actions -->
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group mb-0">
                                    <button type="submit" class="btn btn-success btn-lg" id="saveBtn">
                                        <i class="fas fa-save"></i>
                                        Save Settings
                                        <span class="spinner-border spinner-border-sm d-none" id="saveSpinner"></span>
                                    </button>
                                    
                                    <button type="button" class="btn btn-outline-secondary btn-lg" onclick="resetForm()">
                                        <i class="fas fa-undo"></i>
                                        Reset to Defaults
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Success Modal -->
<div class="modal fade" id="successModal" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-sm" role="document">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">Success</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body text-center">
                <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                <h5>Settings Updated!</h5>
                <p class="mb-0">Channel settings have been updated successfully.</p>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-success" data-dismiss="modal">OK</button>
            </div>
        </div>
    </div>
</div>

<style>
.card {
    border: none;
    border-radius: 10px;
}

.card-header {
    border-radius: 10px 10px 0 0 !important;
}

.form-control {
    border-radius: 8px;
    border: 2px solid #e3e6f0;
    transition: all 0.3s;
}

.form-control:focus {
    border-color: #4e73df;
    box-shadow: 0 0 0 0.2rem rgba(78, 115, 223, 0.25);
}

.btn {
    border-radius: 8px;
    font-weight: 600;
}

.alert {
    border-radius: 8px;
    border: none;
}
</style>

<script>
document.getElementById('settingsForm').addEventListener('submit', function(e) {
    const minMembers = parseInt(document.getElementById('min_channel_members').value);
    const maxMembers = parseInt(document.getElementById('max_channel_members').value);
    
    if (minMembers >= maxMembers) {
        e.preventDefault();
        alert('Error: Maximum members must be greater than minimum members');
        return;
    }
    
    const saveBtn = document.getElementById('saveBtn');
    const spinner = document.getElementById('saveSpinner');
    
    saveBtn.disabled = true;
    spinner.classList.remove('d-none');
});

function resetForm() {
    if (confirm('Are you sure you want to reset all settings to default values?')) {
        document.getElementById('min_channel_members').value = '100';
        document.getElementById('max_channel_members').value = '10000';
        document.getElementById('cost_per_member').value = '0.50';
        document.getElementById('min_order_amount').value = '50';
        document.getElementById('max_orders_per_day').value = '5';
    }
}

// Show success modal if settings were just updated
@if(session('success'))
    $(document).ready(function() {
        $('#successModal').modal('show');
    });
@endif
</script>
@endsection