@extends('layouts.main-layout')

@section('body')
<style>
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .stat-card {
            transition: transform 0.3s ease;
        }
        .stat-card:hover {
            transform: translateY(-5px);
        }
        .badge {
            font-size: 0.75em;
        }
        .table th {
            border-top: none;
            font-weight: 600;
            color: #495057;
        }
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            object-fit: cover;
        }
        .btn-group-sm .btn {
            padding: 0.25rem 0.5rem;
        }
    </style>
<body>
    <div class="container-fluid py-4">
        <!-- Page Header -->
        <div class="d-flex justify-content-between align-items-center mb-4">
            <div>
                <h1 class="h3 text-gray-800">
                    <i class="fab fa-telegram-plane text-primary me-2"></i>
                    Channel Orders Management
                </h1>
                <p class="text-muted mb-0">Manage all Telegram channel orders from users</p>
            </div>
            <a href="{{ route('admin.channel.settings') }}" class="btn btn-primary">
                <i class="fas fa-cog me-2"></i>Channel Settings
            </a>
        </div>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-xl-2 col-md-4 mb-4">
                <div class="card border-left-primary shadow h-100 py-2 stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                    Total Orders
                                </div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $orders->count() }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-list-alt fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-2 col-md-4 mb-4">
                <div class="card border-left-warning shadow h-100 py-2 stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                    Pending
                                </div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $orders->where('status', 'pending')->count() }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-clock fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-2 col-md-4 mb-4">
                <div class="card border-left-info shadow h-100 py-2 stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                    Approved
                                </div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $orders->where('status', 'approved')->count() }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-2 col-md-4 mb-4">
                <div class="card border-left-success shadow h-100 py-2 stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                    Completed
                                </div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $orders->where('status', 'completed')->count() }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-trophy fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-2 col-md-4 mb-4">
                <div class="card border-left-danger shadow h-100 py-2 stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                    Rejected
                                </div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">{{ $orders->where('status', 'rejected')->count() }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-xl-2 col-md-4 mb-4">
                <div class="card border-left-secondary shadow h-100 py-2 stat-card">
                    <div class="card-body">
                        <div class="row no-gutters align-items-center">
                            <div class="col mr-2">
                                <div class="text-xs font-weight-bold text-secondary text-uppercase mb-1">
                                    Total Revenue
                                </div>
                                <div class="h5 mb-0 font-weight-bold text-gray-800">৳{{ number_format($orders->sum('total_cost'), 2) }}</div>
                            </div>
                            <div class="col-auto">
                                <i class="fas fa-money-bill-wave fa-2x text-gray-300"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Filter Buttons -->
        <div class="row mb-3">
            <div class="col-12">
                <div class="btn-group" role="group">
                    <button type="button" class="btn btn-outline-primary active filter-btn" data-status="all">
                        All Orders
                    </button>
                    <button type="button" class="btn btn-outline-warning filter-btn" data-status="pending">
                        Pending
                    </button>
                    <button type="button" class="btn btn-outline-info filter-btn" data-status="approved">
                        Approved
                    </button>
                    <button type="button" class="btn btn-outline-success filter-btn" data-status="completed">
                        Completed
                    </button>
                    <button type="button" class="btn btn-outline-danger filter-btn" data-status="rejected">
                        Rejected
                    </button>
                </div>
            </div>
        </div>

        <!-- Orders Table -->
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">Channel Orders List</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    @if($orders->count() > 0)
                    <table class="table table-bordered" id="ordersTable" width="100%" cellspacing="0">
                        <thead>
                            <tr>
                                <th>Order ID</th>
                                <th>User</th>
                                <th>Channel</th>
                                <th>Members</th>
                                <th>Amount</th>
                                <th>Status</th>
                                <th>Admin Status</th>
                                <th>Date</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($orders as $order)
                            <tr class="order-row" data-status="{{ $order->status }}">
                                <td>#{{ $order->id }}</td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        @if($order->user->profile_image)
                                            <img class="user-avatar me-2" 
                                                 src="{{ asset('uploads/profile_images/' . $order->user->profile_image) }}" 
                                                 alt="User Avatar">
                                        @else
                                            <div class="user-avatar bg-primary text-white d-flex align-items-center justify-content-center me-2" 
                                                 style="font-weight: bold;">
                                                {{ substr($order->user->fname, 0, 1) }}
                                            </div>
                                        @endif
                                        <div>
                                            <div class="fw-bold">{{ $order->user->fname }}</div>
                                            <small class="text-muted">{{ $order->user->email }}</small>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <strong>@{{ $order->channel_username }}</strong>
                                    <br>
                                    <small class="text-muted">Telegram ID: {{ $order->user->telegram_user_id ?? 'N/A' }}</small>
                                </td>
                                <td>
                                    <span class="fw-bold text-primary">{{ number_format($order->member_count) }}</span>
                                </td>
                                <td>
                                    <span class="fw-bold text-success">৳{{ number_format($order->total_cost, 2) }}</span>
                                    <br>
                                    <small class="text-muted">@ ৳{{ $order->cost_per_member }}/member</small>
                                </td>
                                <td>
                                    @if($order->status == 'pending')
                                        <span class="badge bg-warning">Pending</span>
                                    @elseif($order->status == 'approved')
                                        <span class="badge bg-info">Approved</span>
                                    @elseif($order->status == 'completed')
                                        <span class="badge bg-success">Completed</span>
                                    @else
                                        <span class="badge bg-danger">Rejected</span>
                                    @endif
                                </td>
                                <td>
                                    @if($order->admin_approved)
                                        <span class="badge bg-success">Approved</span>
                                    @else
                                        <span class="badge bg-warning">Pending</span>
                                    @endif
                                    <br>
                                    @if($order->bot_admin)
                                        <span class="badge bg-info">Bot Added</span>
                                    @else
                                        <span class="badge bg-secondary">No Bot</span>
                                    @endif
                                </td>
                                <td>
                                    {{ $order->created_at->format('M d, Y') }}
                                    <br>
                                    <small class="text-muted">{{ $order->created_at->format('h:i A') }}</small>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm">
                                        @if($order->status == 'pending')
                                            <a href="{{ route('admin.channel.order.approve', $order->id) }}" 
                                               class="btn btn-success" 
                                               title="Approve Order"
                                               onclick="return confirm('Approve this order? This will verify bot admin status.')">
                                                <i class="fas fa-check"></i>
                                            </a>
                                            <a href="{{ route('admin.channel.order.reject', $order->id) }}" 
                                               class="btn btn-danger"
                                               title="Reject Order"
                                               onclick="return confirm('Reject this order? Amount will be refunded to user.')">
                                                <i class="fas fa-times"></i>
                                            </a>
                                        @elseif($order->status == 'approved')
                                            <a href="{{ route('admin.channel.order.complete', $order->id) }}" 
                                               class="btn btn-info"
                                               title="Mark Complete"
                                               onclick="return confirm('Mark this order as completed?')">
                                                <i class="fas fa-flag-checkered"></i>
                                            </a>
                                            <a href="{{ route('admin.channel.order.reject', $order->id) }}" 
                                               class="btn btn-danger"
                                               title="Reject Order"
                                               onclick="return confirm('Reject this order? Amount will be refunded to user.')">
                                                <i class="fas fa-times"></i>
                                            </a>
                                        @elseif($order->status == 'completed')
                                            <button class="btn btn-success" disabled title="Completed">
                                                <i class="fas fa-check-double"></i>
                                            </button>
                                        @else
                                            <button class="btn btn-danger" disabled title="Rejected">
                                                <i class="fas fa-ban"></i>
                                            </button>
                                        @endif
                                        
                                        <button type="button" class="btn btn-primary" 
                                                onclick="showOrderDetails({{ $order->id }})"
                                                title="View Details">
                                            <i class="fas fa-eye"></i>
                                        </button>
                                    </div>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @else
                    <div class="text-center py-5">
                        <i class="fas fa-inbox fa-4x text-muted mb-3"></i>
                        <h4 class="text-muted">No Channel Orders Yet</h4>
                        <p class="text-muted">No users have placed any channel orders yet.</p>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Order Details Modal -->
    <div class="modal fade" id="orderDetailsModal" tabindex="-1" aria-labelledby="orderDetailsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="orderDetailsModalLabel">Order Details</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="orderDetailsContent">
                    <!-- Details will be loaded here -->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    
    <script>
        // Filter functionality
        document.querySelectorAll('.filter-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                // Update active button
                document.querySelectorAll('.filter-btn').forEach(b => {
                    b.classList.remove('active');
                });
                this.classList.add('active');
                
                const status = this.getAttribute('data-status');
                filterOrders(status);
            });
        });

        function filterOrders(status) {
            const rows = document.querySelectorAll('.order-row');
            rows.forEach(row => {
                if (status === 'all' || row.getAttribute('data-status') === status) {
                    row.style.display = '';
                } else {
                    row.style.display = 'none';
                }
            });
        }

        function showOrderDetails(orderId) {
            // For now, we'll show a simple alert. In real implementation, you'd fetch order details via AJAX
            const orderRow = document.querySelector(`tr[data-status][data-id="${orderId}"]`);
            if (orderRow) {
                const orderData = {
                    id: orderId,
                    channel_username: orderRow.cells[2].querySelector('strong').textContent,
                    member_count: orderRow.cells[3].textContent.trim(),
                    total_cost: orderRow.cells[4].querySelector('.fw-bold').textContent,
                    status: orderRow.getAttribute('data-status')
                };
                
                document.getElementById('orderDetailsContent').innerHTML = `
                    <div class="row">
                        <div class="col-md-6">
                            <h6>Order Information</h6>
                            <table class="table table-sm">
                                <tr>
                                    <td><strong>Order ID:</strong></td>
                                    <td>#${orderData.id}</td>
                                </tr>
                                <tr>
                                    <td><strong>Channel:</strong></td>
                                    <td>${orderData.channel_username}</td>
                                </tr>
                                <tr>
                                    <td><strong>Members:</strong></td>
                                    <td>${orderData.member_count}</td>
                                </tr>
                                <tr>
                                    <td><strong>Total Amount:</strong></td>
                                    <td class="fw-bold text-success">${orderData.total_cost}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <h6>Status Information</h6>
                            <table class="table table-sm">
                                <tr>
                                    <td><strong>Order Status:</strong></td>
                                    <td><span class="badge bg-${getStatusColor(orderData.status)}">${orderData.status.charAt(0).toUpperCase() + orderData.status.slice(1)}</span></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                `;
            } else {
                document.getElementById('orderDetailsContent').innerHTML = `
                    <div class="text-center text-muted">
                        <i class="fas fa-exclamation-circle fa-3x mb-3"></i>
                        <p>Order details not found.</p>
                    </div>
                `;
            }
            
            const modal = new bootstrap.Modal(document.getElementById('orderDetailsModal'));
            modal.show();
        }

        function getStatusColor(status) {
            switch(status) {
                case 'pending': return 'warning';
                case 'approved': return 'info';
                case 'completed': return 'success';
                case 'rejected': return 'danger';
                default: return 'secondary';
            }
        }

        // Initialize DataTable
        $(document).ready(function() {
            $('#ordersTable').DataTable({
                pageLength: 25,
                order: [[0, 'desc']],
                language: {
                    search: "Search orders:"
                }
            });
        });
    </script>
</body>
@endsection