@extends('layouts.main-layout')

@section('body')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header bg-primary text-white">
                    <h4 class="mb-0"><i class="fas fa-gift"></i> Manage Gift Codes</h4>
                </div>
                <div class="card-body">
                    <!-- Create Gift Code Form -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header bg-success text-white">
                                    <h5 class="mb-0">Create New Gift Code</h5>
                                </div>
                                <div class="card-body">
                                    <form method="POST" action="{{ route('admin.gift.codes.store') }}">
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>Code *</label>
                                                    <input type="text" name="code" class="form-control" required 
                                                           placeholder="e.g., WELCOME100">
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Amount (৳) *</label>
                                                    <input type="number" name="amount" class="form-control" 
                                                           step="0.01" min="0.01" required>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Max Uses *</label>
                                                    <input type="number" name="max_uses" class="form-control" 
                                                           min="1" value="1" required>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Valid From *</label>
                                                    <input type="datetime-local" name="valid_from" class="form-control" required>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label>Valid Until *</label>
                                                    <input type="datetime-local" name="valid_until" class="form-control" required>
                                                </div>
                                            </div>
                                            <div class="col-md-1">
                                                <div class="form-group">
                                                    <label>&nbsp;</label>
                                                    <button type="submit" class="btn btn-success btn-block">
                                                        <i class="fas fa-plus"></i> Create
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Gift Codes List -->
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Code</th>
                                    <th>Amount</th>
                                    <th>Uses</th>
                                    <th>Valid From</th>
                                    <th>Valid Until</th>
                                    <th>Status</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($giftCodes as $giftCode)
                                    <tr>
                                        <td><code>{{ $giftCode->code }}</code></td>
                                        <td class="text-success">৳{{ number_format($giftCode->amount, 2) }}</td>
                                        <td>{{ $giftCode->used_count }} / {{ $giftCode->max_uses }}</td>
                                        <td>{{ $giftCode->valid_from->format('M d, Y h:i A') }}</td>
                                        <td>{{ $giftCode->valid_until->format('M d, Y h:i A') }}</td>
                                        <td>
                                            @if($giftCode->isValid())
                                                <span class="badge badge-success">Active</span>
                                            @else
                                                <span class="badge badge-danger">Inactive</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ route('admin.gift.codes.toggle', $giftCode->id) }}" 
                                               class="btn btn-sm btn-{{ $giftCode->is_active ? 'warning' : 'success' }}">
                                                {{ $giftCode->is_active ? 'Deactivate' : 'Activate' }}
                                            </a>
                                            <a href="{{ route('admin.gift.codes.delete', $giftCode->id) }}" 
                                               class="btn btn-sm btn-danger" 
                                               onclick="return confirm('Are you sure?')">
                                                Delete
                                            </a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection