@extends('layouts.main-layout')

@section('body')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">Ads Management</h3>
                </div>
                <div class="card-body">
                    
                    <!-- Pending Ads -->
                    <h4>Pending Ads ({{ $pendingAds->count() }})</h4>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>User</th>
                                    <th>Image</th>
                                    <th>Link</th>
                                    <th>Duration</th>
                                    <th>Amount</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($pendingAds as $ad)
                                <tr>
                                    <td>{{ $ad->user->name }} ({{ $ad->user->email }})</td>
                                    <td>
                                        <img src="{{ asset('ads_images/' . $ad->image) }}" alt="Ad Image" style="width: 100px; height: auto;">
                                    </td>
                                    <td><a href="{{ $ad->link }}" target="_blank">{{ Str::limit($ad->link, 30) }}</a></td>
                                    <td>{{ $ad->duration_hours }} hours</td>
                                    <td>৳{{ $ad->amount }}</td>
                                    <td>{{ $ad->created_at->format('d M Y h:i A') }}</td>
                                    <td>
                                        <form action="{{ route('admin.ads.approve', $ad->id) }}" method="POST" style="display: inline;">
                                            @csrf
                                            <button type="submit" class="btn btn-success btn-sm">Approve</button>
                                        </form>
                                        <form action="{{ route('admin.ads.reject', $ad->id) }}" method="POST" style="display: inline;">
                                            @csrf
                                            <button type="submit" class="btn btn-danger btn-sm">Reject</button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Active Ads -->
                    <h4 class="mt-5">Active Ads ({{ $activeAds->count() }})</h4>
                    <div class="table-responsive">
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>User</th>
                                    <th>Image</th>
                                    <th>Link</th>
                                    <th>Duration</th>
                                    <th>Start Time</th>
                                    <th>End Time</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($activeAds as $ad)
                                <tr>
                                    <td>{{ $ad->user->name }}</td>
                                    <td>
                                        <img src="{{ asset('ads_images/' . $ad->image) }}" alt="Ad Image" style="width: 100px; height: auto;">
                                    </td>
                                    <td><a href="{{ $ad->link }}" target="_blank">{{ Str::limit($ad->link, 30) }}</a></td>
                                    <td>{{ $ad->duration_hours }} hours</td>
                                    <td>{{ $ad->start_time->format('d M Y h:i A') }}</td>
                                    <td>{{ $ad->end_time->format('d M Y h:i A') }}</td>
                                    <td>
                                        <form action="{{ route('admin.ads.delete', $ad->id) }}" method="POST" style="display: inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection