<?php
// app/Models/UserChannelJoin.php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class UserChannelJoin extends Model
{
    use HasFactory;

    protected $table = 'user_channel_joins';

    protected $fillable = [
        'user_id',
        'channel_order_id',
        'joined_at',
        'earned'
    ];

    protected $casts = [
        'joined_at' => 'datetime',
        'earned' => 'boolean'
    ];

    // Relations
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function channelOrder()
    {
        return $this->belongsTo(ChannelOrder::class, 'channel_order_id');
    }
}