<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;

class User extends Authenticatable {

    protected $table = 'users';

    protected $fillable = [
        'fname',
        'phone',
        'email',
        'password',
        'balance',
        'deposit_balance', // নতুন যোগ করুন
        'total_spent',
        'device_id',
        'user_active',
        'ref_code',
        'ref_by',
        'today_job',
        'today_orders',
        'profile_image',
        'telegram_user_id',
        'tg_id_status',
        'api_selling_limit', // নতুন যোগ করুন
        'api_selling_count',
        'last_api_reset',
        'bonus_claimed',
        'ura',
        'usa'
    ];



    public function withdraw()
    {
        return $this->hasMany(Withdraw::class);
    }
    
    protected $attributes = [
        'api_selling_limit' => 4,
    ];
    
    public function apiSellingHistories()
{
    return $this->hasMany(ApiSellingHistory::class);
}

    public function referrals()
    {
        return $this->hasMany(User::class, 'ref_by', 'id');
    }

    public function referrer()
    {
        return $this->belongsTo(User::class, 'ref_by', 'id');
    }

    public function channelOrders()
    {
        return $this->hasMany(ChannelOrder::class);
    }
}