<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LotteryParticipant extends Model
{
    protected $fillable = [
        'lottery_id',
        'user_id',
        'ticket_number',
        'has_won',
        'prize_type',
        'prize_amount',
        'is_claimed'
    ];

    protected $casts = [
        'has_won' => 'boolean',
        'is_claimed' => 'boolean',
        'prize_amount' => 'decimal:2'
    ];

    public function lottery()
    {
        return $this->belongsTo(Lottery::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function generateTicketNumber()
    {
        return 'TKT' . time() . rand(1000, 9999);
    }
}