<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Lottery extends Model
{
    protected $fillable = [
        'lottery_date',
        'join_amount',
        'first_prize',
        'second_prize',
        'third_prize',
        'winners',
        'is_completed'
    ];

    protected $casts = [
        'winners' => 'array',
        'join_amount' => 'decimal:2',
        'first_prize' => 'decimal:2',
        'second_prize' => 'decimal:2',
        'third_prize' => 'decimal:2',
        'is_completed' => 'boolean'
    ];

    public function participants()
    {
        return $this->hasMany(LotteryParticipant::class);
    }

    public function getTotalParticipantsAttribute()
    {
        return $this->participants()->count();
    }

    public function getTodayLottery()
    {
        return self::where('lottery_date', today()->toDateString())->first();
    }
}