<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GiftCodeRedemption extends Model
{
    use HasFactory;

    // Timestamps disable করুন
    public $timestamps = false;

    protected $fillable = [
        'gift_code_id',
        'user_id',
        'redeemed_amount'
    ];

    protected $casts = [
        'redeemed_amount' => 'decimal:2',
        'redeemed_at' => 'datetime'
    ];

    public function giftCode()
    {
        return $this->belongsTo(GiftCode::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}