<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GiftCode extends Model
{
    use HasFactory;

    protected $fillable = [
        'code',
        'amount',
        'max_uses',
        'used_count',
        'valid_from',
        'valid_until',
        'is_active',
        'created_by'
    ];

    protected $casts = [
        'valid_from' => 'datetime',
        'valid_until' => 'datetime',
        'is_active' => 'boolean',
        'amount' => 'decimal:2'
    ];

    // creator relationship সরিয়ে নিন অথবা comment করুন
    /*
    public function creator()
    {
        return $this->belongsTo(Admin::class, 'created_by');
    }
    */

    public function isValid()
    {
        if (!$this->is_active) {
            return false;
        }
        
        if ($this->used_count >= $this->max_uses) {
            return false;
        }
        
        $now = now();
        if ($now->lt($this->valid_from) || $now->gt($this->valid_until)) {
            return false;
        }
        
        return true;
    }
}