<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ChannelOrder extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'channel_username',
        'member_count',
        'cost_per_member',
        'total_cost',
        'status',
        'admin_approved',
        'bot_admin',
        'order_date'
    ];

    protected $attributes = [
        'status' => 'pending',
        'admin_approved' => false,
        'bot_admin' => false
    ];

    protected $casts = [
        'admin_approved' => 'boolean',
        'bot_admin' => 'boolean',
        'cost_per_member' => 'decimal:2',
        'total_cost' => 'decimal:2'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}