<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Ad extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'image',
        'link',
        'duration_hours',
        'amount',
        'views',  // এই লাইনটি যুক্ত করুন
        'clicks', // এই লাইনটি যুক্ত করুন
        'status',
        'start_time',
        'end_time',
        'ad_name'
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'start_time' => 'datetime',
        'end_time' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function scopeActive($query)
    {
        return $query->where('status', 'approved')
                    ->where('end_time', '>', now());
    }

    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }
}