<?php
namespace App\Http\Controllers\user;
use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Validation\Rules\Password;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Auth;
class indexController extends Controller
{
    public function index(){
        return view('user.index');
    }
    public function catalog(){
        return view('user.catalog');
    }
    public function login(){
        return view('user.login');
    }
    public function register(){
        return view('user.register');
    }
  public function register_submit(Request $request)
{
    $ip = $request->ip();
    $response = Http::get("http://ip-api.com/json/{$ip}?fields=status,countryCode,message");
    if ($response->successful()) {
        $data = $response->json();
        if ($data['status'] === 'fail') {
            return redirect()->back()->with(["error" => "Register Unsuccessful."]);
        }
        if ($data['countryCode'] !== 'BD') {
            return redirect()->back()->with(["error" => "Register Unsuccessful."]);
        }
    } else {
        return redirect()->back()->with(["error" => "Register Unsuccessful"]);
    }
    
    $request->validate([
        'first_name' => 'nullable|string',
        'email' => 'required|email',
        'phone' => 'required',
        'device_id' => 'nullable|string',
        'password' => ['required', Password::min(8)],
        'password_confirmation' => 'required|same:password',
    ]);

    // Device ID চেক এবং অটো-জেনারেট
    if (empty($request->device_id) || User::where('device_id', $request->device_id)->exists()) {
        do {
            $deviceId = Str::uuid();
        } while (User::where('device_id', $deviceId)->exists());
        $request->merge(['device_id' => $deviceId]);
    }

    if (User::where('phone', $request->phone)->exists()) {
        return redirect()->back()->with(["error" => "Phone number already in use."]);
    }

    // Ref_by চেক
    $ref_by = $request->ref_by;
    if (empty($ref_by) || !User::where('ref_code', $ref_by)->exists()) {
        $ref_by = "ZV3JYCAwLSeZD0";
    }

    $user = User::create([
        'fname' => $request->first_name,
        'email' => $request->email,
        'phone' => $request->phone,
        'device_id' => $request->device_id,
        'password' => Hash::make($request->password),
        'balance' => 0,
        'ref_code' => Str::random(14),
        'ref_by' => $ref_by,
        'api_selling_limit' => 4
    ]);

    if (!empty($ref_by)) {
        $referrer = User::where('ref_code', $ref_by)->first();
        if ($referrer) {
            $referrer->balance += 0;
            $referrer->save();
        }
    }

    if ($user) {
        // ইমেইল পাঠানো
        try {
            \Mail::to($user->email)->send(new \App\Mail\RegistrationSuccessMail($user));
        } catch (\Exception $e) {
            \Log::error('Registration email failed: ' . $e->getMessage());
            // ইমেইল失败 হলেও রেজিস্ট্রেশন সফল হবে
        }

        auth()->login($user);
        return redirect()->route('dashboard')->with([
            "register_success" => "আপনার একাউন্টটি খোলা সফল হয়েছে"
        ]);
    } else {
        return redirect()->back()->with([
            "error" => "আপনার অ্যাকাউন্ট খোলা ব্যর্থ হয়েছে"
        ]);
    }
}
public function login_submit(Request $request)
{
    $request->validate([
        'login_identity' => 'required',
        'login_password' => ['required', Password::min(8)],
    ]);
    $remember = $request->input('login_remember', false);
    $identity = $request->input('login_identity');
    $password = $request->input('login_password');
    // Check whether the input is an email or phone number
    $fieldType = filter_var($identity, FILTER_VALIDATE_EMAIL) ? 'email' : 'phone';
    if (Auth::attempt([$fieldType => $identity, 'password' => $password], $remember)) {
        return redirect()->route('dashboard');
    }
    return redirect()->back()->with('error', 'These credentials do not match our records.');
}

public function forgotPassword()
{
    return view('user.forgot-password');
}

public function forgotPasswordSubmit(Request $request)
{
    $request->validate([
        'email' => 'required|email'
    ]);

    $user = User::where('email', $request->email)->first();

    if (!$user) {
        return redirect()->back()->with('error', 'এই ইমেইল দিয়ে কোনো অ্যাকাউন্ট খুঁজে পাওয়া যায়নি।');
    }


    $code = str_pad(random_int(0, 999999), 6, '0', STR_PAD_LEFT);
    $token = Str::random(60);

    // পুরানো রিসেট কোড ডিলিট করুন
    \DB::table('password_reset_codes')->where('email', $request->email)->delete();

    // নতুন রিসেট কোড সেভ করুন (10 মিনিটের জন্য ভ্যালিড)
    \DB::table('password_reset_codes')->insert([
        'email' => $request->email,
        'code' => $code,
        'token' => $token,
        'expires_at' => now()->addMinutes(10),
        'created_at' => now(),
        'updated_at' => now()
    ]);

    try {
        // ইমেইল পাঠান
        \Mail::send('emails.password-reset', ['code' => $code], function($message) use ($request) {
            $message->to($request->email);
            $message->subject('Password Reset Code - ' . config('app.name'));
        });

        return redirect()->route('reset.password', $token)->with('success', '৬ ডিজিটের ভেরিফিকেশন কোডটি আপনার ইমেইলে পাঠানো হয়েছে।');

    } catch (\Exception $e) {
        return redirect()->back()->with('error', 'ইমেইল পাঠানো যায়নি। পরে আবার চেষ্টা করুন।');
    }
}

public function resetPassword($token)
{
    $resetCode = \DB::table('password_reset_codes')
                    ->where('token', $token)
                    ->where('expires_at', '>', now())
                    ->first();

    if (!$resetCode) {
        return redirect()->route('forgot.password')->with('error', 'ইনভ্যালিড বা এক্সপায়ার্ড লিংক।');
    }

    return view('user.reset-password', compact('token'));
}

public function resetPasswordSubmit(Request $request)
{
    $request->validate([
        'token' => 'required',
        'code' => 'required|digits:6',
        'password' => ['required', 'confirmed', Password::min(8)]
    ]);

    $resetCode = \DB::table('password_reset_codes')
                    ->where('token', $request->token)
                    ->where('code', $request->code)
                    ->where('expires_at', '>', now())
                    ->first();

    if (!$resetCode) {
        return redirect()->back()->with('error', 'ইনভ্যালিড বা এক্সপায়ার্ড ভেরিফিকেশন কোড।');
    }

    // ইউজারের পাসওয়ার্ড আপডেট করুন
    $user = User::where('email', $resetCode->email)->first();
    if ($user) {
        $user->password = Hash::make($request->password);
        $user->save();

        // রিসেট কোড ডিলিট করুন
        \DB::table('password_reset_codes')->where('email', $resetCode->email)->delete();

        // অটো লগিন করান
        Auth::login($user);

        return redirect()->route('dashboard')->with('success', 'পাসওয়ার্ড সফলভাবে রিসেট হয়েছে। আপনি এখন লগইন অবস্থায় আছেন।');
    }

    return redirect()->route('login')->with('error', 'ইউজার খুঁজে পাওয়া যায়নি।');
}

}