<?php
namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Http;
use App\Models\Job;
use App\Models\JobSubmit;
use App\Models\Notice;
use App\Models\Payment;
use App\Models\GiftCode;
use App\Models\GiftCodeRedemption;
use App\Models\User;
use App\Models\Ad;
use App\Models\Lottery;
use App\Models\UserChannelJoin;
use App\Models\ApiSellingHistory;
use App\Models\Withdraw;
use App\Models\LotteryParticipant;
use App\Mail\PaymentSuccessMail;
use Illuminate\Support\Facades\Mail;
use App\Models\ChannelOrder;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\EarningHistory;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Database\QueryException;

class dashController extends Controller
{
    public function dashboard(Request $request)
    {
        if (auth()->user()->deactive == "yes") {
            Auth::logout();
            $request->session()->invalidate();
            return redirect()->route('login')->with("error", "Account Banned");
        }

        $userId = Auth::id();
        $data = Notice::get();

        $amountSetting = DB::table('settings')->where('key', 'per_sentence_amount')->value('value');
        $amountPerSentence = floatval($amountSetting ?? 2);

        $sentenceCount = DB::table('sentence_history')
            ->where('user_id', $userId)
            ->count();
        $sentenceEarnings = $sentenceCount * $amountPerSentence;

        $user = DB::table('users')->where('id', $userId)->first();

        $totalWithdrawalAmount = Withdraw::where('user_id', auth()->user()->id)->sum('amount');
        $totalCollectedAmount = EarningHistory::where('user_id', auth()->user()->id)
            ->where('type', 'collected')
            ->sum('earned_amount');

        $totalPendingAmount = EarningHistory::where('user_id', auth()->user()->id)
            ->where('type', 'pending')
            ->sum('earned_amount');

        $referralEarnings = DB::table('referral_earnings')
            ->where('user_id', $userId)
            ->sum('amount');

        $totalPayments = DB::table('payments')
            ->where('user_id', $userId)
            ->where('status', 'approved')
            ->selectRaw('SUM(CAST(amount AS DECIMAL(10,2))) as total')
            ->value('total');

        $totalEarned = $totalCollectedAmount + $referralEarnings + $sentenceEarnings;

        return view('user.dashboard', compact(
            'data',
            'totalWithdrawalAmount',
            'totalCollectedAmount',
            'totalPendingAmount',
            'totalEarned',
            'sentenceEarnings',
            'referralEarnings',
            'totalPayments'
        ));
    }
          
          
          
          public function gjobs()
    {
        $user = Auth::user(); 
        
       
        $this->resetDailySubmissionLimit($user);

        return view('user.gjobs', compact('user'));
    }
    
  
  public function telegramJobs()
{
    $user = Auth::user();

    if ($user->tg_id_status != 1) {
        return view('user.telegram_jobs', [
            'needsTelegram' => true,
            'channels' => collect()
        ]);
    }

    // Only approved channels
    $channels = ChannelOrder::where('admin_approved', true)
        ->where('status', 'approved')
        ->get();

    return view('user.telegram_jobs', [
        'needsTelegram' => false,
        'channels' => $channels
    ]);
}

public function verifyJoin(Request $request)
{
    $request->validate([
        'channel_id' => 'required|exists:channel_orders,id',
    ]);

    $user = Auth::user();
    $channel = ChannelOrder::findOrFail($request->channel_id);

    // Already completed?
    if (UserChannelJoin::where('user_id', $user->id)
            ->where('channel_order_id', $channel->id)->exists()) {
        return response()->json([
            'success' => false,
            'message' => 'Already completed!'
        ]);
    }

    // Telegram ID connected?
    if (!$user->telegram_user_id || $user->tg_id_status != 1) {
        return response()->json([
            'success' => false,
            'message' => 'Connect & verify Telegram ID first.'
        ]);
    }

    $botToken       = '8315254246:AAG3fcJgamO4L4rzr70bfngTn-kSXAnAoZ4';
    $chatUsername   = '@' . ltrim($channel->channel_username, '@');
    $userTelegramId = $user->telegram_user_id;

    $apiUrl = "https://api.telegram.org/bot{$botToken}/getChatMember"
            . "?chat_id={$chatUsername}&user_id={$userTelegramId}";

    Log::info('Telegram API Call', [
        'url' => $apiUrl,
        'user_id' => $userTelegramId,
        'channel' => $chatUsername
    ]);

    try {

        $response = Http::timeout(20)->get($apiUrl);

        if (!$response->ok()) {
            Log::error('Telegram API HTTP Error', [
                'status' => $response->status(),
                'body' => $response->body(),
                'url' => $apiUrl
            ]);

            return response()->json([
                'success' => false,
                'message' => 'Telegram API unreachable. Try again later.'
            ]);
        }

        $data = $response->json();

        Log::info('Telegram API Response', $data);

        // Telegram says error
        if (empty($data['ok'])) {
            $desc = $data['description'] ?? 'Unknown error';

            return response()->json([
                'success' => false,
                'message' => "Telegram error: $desc"
            ]);
        }

        // Get user status
        $status = $data['result']['status'] ?? 'left';

        if (in_array($status, ['member', 'administrator', 'creator'])) {

            $earning = $channel->total_cost / max($channel->member_count, 1);

            UserChannelJoin::create([
                'user_id'          => $user->id,
                'channel_order_id' => $channel->id,
                'earned'           => true
            ]);

            $user->increment('balance', $earning);

            return response()->json([
                'success'     => true,
                'message'     => "৳" . number_format($earning, 2) . " added!",
                'new_balance' => number_format($user->fresh()->balance, 2)
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'Not joined yet. Click "Join Channel" first.'
        ]);

    } catch (\Exception $e) {

        Log::error('Telegram API Exception', [
            'error' => $e->getMessage(),
            'api_url' => $apiUrl
        ]);

        return response()->json([
            'success' => false,
            'message' => 'API connection failed: ' . $e->getMessage()
        ]);
    }
}

// Ads related methods
public function ads()
{
    $user = Auth::user();
    $ads = Ad::where('user_id', $user->id)->latest()->get();
    return view('user.ads', compact('ads'));
}

// এই ফাংশনটি ক্লাসের ভেতরে সবার শেষে যুক্ত করুন
    public function trackAdClick($id)
    {
        $ad = \App\Models\Ad::find($id);

        if ($ad) {
            // ক্লিক কাউন্ট ১ বাড়াবে
            $ad->increment('clicks');
            
            // আসল লিংকে পাঠিয়ে দিবে
            return redirect()->away($ad->link);
        }

        return back()->with('error', 'Ad link not found');
    }

public function lottery()
{
    $todayLottery = Lottery::where('lottery_date', today()->toDateString())->first();
    
    // ✅ AUTO CREATE TODAY'S LOTTERY IF NOT EXISTS
    if (!$todayLottery) {
        $todayLottery = Lottery::create([
            'lottery_date' => today()->toDateString(),
            'join_amount' => 10,
            'first_prize' => 100,
            'second_prize' => 50,
            'third_prize' => 25
        ]);
    }

    $userParticipation = null;
    if (auth()->check()) {
        $userParticipation = $todayLottery->participants()
            ->where('user_id', auth()->id())
            ->first();
    }

    // ✅ SMART NEXT DRAW TIME CALCULATION (TARGET: 23:50)
    // আজকের রাত ১১:৫০ (23:50:00) টার্গেট টাইম হিসেবে সেট করা হলো
    $targetTimeToday = now()->setTime(23, 50, 0);

    if ($todayLottery->is_completed || now()->greaterThan($targetTimeToday)) {
        // লজিক: যদি আজকের লটারি 'completed' হয় অথবা ঘড়িতে ২৩:৫০ এর বেশি বেজে যায়
        // তাহলে 'Next Draw Time' হবে আগামীকালের ২৩:৫০
        $nextDrawTime = now()->addDay()->setTime(23, 50, 0);
    } else {
        // অন্যথায়, আজকের ২৩:৫০ তেই কাউন্টডাউন হবে
        $nextDrawTime = $targetTimeToday;
    }

    return view('user.lottery', compact(
        'todayLottery', 
        'userParticipation',
        'nextDrawTime'
    ));
}

public function joinLottery(Request $request)
{
    $user = auth()->user();
    $todayLottery = \App\Models\Lottery::where('lottery_date', today()->toDateString())->first();

    if (!$todayLottery) {
        return redirect()->back()->with('error', 'Lottery not found for today.');
    }

    if ($todayLottery->is_completed) {
        return redirect()->back()->with('error', 'Today\'s lottery draw has already been completed.');
    }

    // Check if user already participated
    $existingParticipation = $todayLottery->participants()
        ->where('user_id', $user->id)
        ->first();

    if ($existingParticipation) {
        return redirect()->back()->with('error', 'You have already joined today\'s lottery.');
    }

    // Check user balance
    if ($user->balance < $todayLottery->join_amount) {
        return redirect()->back()->with('error', 'Insufficient balance to join lottery.');
    }

    // Deduct join amount
    $user->decrement('balance', $todayLottery->join_amount);

    // Create participation
    $participant = \App\Models\LotteryParticipant::create([
        'lottery_id' => $todayLottery->id,
        'user_id' => $user->id,
        'ticket_number' => (new \App\Models\LotteryParticipant())->generateTicketNumber()
    ]);

    return redirect()->back()->with('success', 'Successfully joined the lottery! Good luck!');
}

public function claimLotteryPrize(Request $request)
{
    $user = auth()->user();
    $todayLottery = \App\Models\Lottery::where('lottery_date', today()->toDateString())->first();

    if (!$todayLottery) {
        return redirect()->back()->with('error', 'Lottery not found.');
    }

    $userParticipation = $todayLottery->participants()
        ->where('user_id', $user->id)
        ->where('has_won', true)
        ->where('is_claimed', false)
        ->first();

    if (!$userParticipation) {
        return redirect()->back()->with('error', 'No unclaimed prize found.');
    }

    // Mark as claimed
    $userParticipation->update(['is_claimed' => true]);

    return redirect()->back()->with('success', 'Prize claimed successfully!');
}

public function createAd()
{
    $ratePerHour = env('AD_RATE_PER_HOUR', 40);
    
    // নতুন কোড - env থেকে ডাটা নেওয়া
    $minViews = env('AD_IMPRESSION_MIN', 3300); 
    $maxViews = env('AD_IMPRESSION_MAX', 5000);
    
    // Calculate estimated start time
    $lastActiveAd = \App\Models\Ad::active()->latest('end_time')->first();
    $estimatedStartTime = now();
    
    if ($lastActiveAd && $lastActiveAd->end_time > now()) {
        $estimatedStartTime = $lastActiveAd->end_time;
    }
    
    // Get all pending ads that will run before this one
    $pendingAds = \App\Models\Ad::where('status', 'pending')
        ->orWhere(function($query) {
            $query->where('status', 'approved')
                  ->where('start_time', '>', now());
        })
        ->orderBy('start_time')
        ->get();

    $totalPendingHours = 0;
    foreach ($pendingAds as $pendingAd) {
        $totalPendingHours += $pendingAd->duration_hours;
    }

    $estimatedStartTime = $estimatedStartTime->copy()->addHours($totalPendingHours);

    return view('user.create_ad', compact('ratePerHour', 'estimatedStartTime'));
}

public function storeAd(Request $request)
{
    // ১. সাধারণ ভ্যালিডেশন (এখানে ইমেজ required রাখা যাবে না)
    $request->validate([
        'link' => 'required|url',
        'duration_hours' => 'required|integer|min:1',
        // ad_type টা ফ্রন্টএন্ড থেকে আসছে কি না চেক করা হচ্ছে
        'ad_type' => 'required|in:manual,telegram,website', 
    ]);

    $imageName = '';

    // ২. কন্ডিশনাল লজিক (ইমেজ হ্যান্ডলিং)
    if ($request->ad_type == 'manual') {
        // যদি Manual হয়, শুধুমাত্র তখনই ইমেজ বাধ্যতামূলক (Required)
        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time() . '_' . uniqid() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('ads_images'), $imageName);
        }
    } 
    elseif ($request->ad_type == 'telegram') {
        // Telegram হলে অটোমেটিক join.jpg সেট হবে
        $imageName = 'join.jpg';
    } 
    else {
        // Website হলে অটোমেটিক click.jpg সেট হবে
        $imageName = 'click.jpg';
    }

    // রেট ক্যালকুলেশন
    $ratePerHour = env('AD_RATE_PER_HOUR', 30);
    $amount = $request->duration_hours * $ratePerHour;

    // ৩. সেশনে ডাটা স্টোর করা
    $adData = [
        'user_id' => Auth::id(),
        'image' => $imageName, // এখানে লজিক অনুযায়ী নাম বসবে
        'link' => $request->link,
        'ad_name' => $request->ad_name,
        'duration_hours' => $request->duration_hours,
        'amount' => $amount,
        'ad_type' => $request->ad_type, // ফিউচার রেকর্ডের জন্য টাইপ রাখা ভালো
        'status' => 'pending'
    ];

    // পেমেন্টের জন্য সেশনে রাখা
    session(['pending_ad' => $adData]);

    return redirect()->route('ads.payment');
}

public function adsPayment()
{
    $pendingAd = session('pending_ad');
    
    if (!$pendingAd) {
        return redirect()->route('ads.create')->with('error', 'Please create an ad first.');
    }

    return view('user.ads_payment', compact('pendingAd'));
}

public function processAdPayment(Request $request)
{
    $pendingAd = session('pending_ad');
    
    if (!$pendingAd) {
        return redirect()->route('ads.create')->with('error', 'Please create an ad first.');
    }

    $request->validate([
        'amount' => 'required|numeric|min:'.$pendingAd['amount']
    ]);

    $amount = $request->amount;
    $user = Auth::user();

    $config = include('../doniapay.php');

    $curl = curl_init();
    $postData = [
        "success_url" => route('ads.payment.status') . "?amount={$amount}",
        "cancel_url" => route('ads.payment.status', 'cancel'),
        "metadata" => [
            "phone" => $user->phone ?? '',
            "user_id" => $user->id
        ],
        "amount" => (string) $amount,
    ];

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://pay.bot-pay.shop/api/payment/create',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode($postData),
        CURLOPT_HTTPHEADER => array(
            'API-KEY: 1KY0oVVommV2o0RyEOOV59iwJTimEpKxLk5wP1UNvHwicrV6pD',
            'Content-Type: application/json',
            'SECRET-KEY: YourSecretKeyHere',
            'BRAND-KEY: YourBrandKeyHere'
        ),
    ));

    $response = curl_exec($curl);
    curl_close($curl);
    $responseData = json_decode($response);

    if (isset($responseData->payment_url)) {
        return redirect()->away($responseData->payment_url);
    } else {
        return redirect()->back()->with('error', 'Payment gateway error. Try again.');
    }
}

public function adsPaymentStatus(Request $request)
{
    $config = include('../doniapay.php');

    // Get amount from query string (same as deposit)
    $amount = $request->query('amount', 0);
    $payment_status = $request->status;
    $action = $request->route('action'); // for cancel route

    // Handle manual cancellation (if user clicks "cancel" on payment page)
    if ($action === 'cancel') {
        $this->cleanPendingAdSession();
        return redirect()->route('ads')->with('error', 'Payment cancelled.');
    }

    // Only proceed if payment is marked as completed and amount > 0
    if ($payment_status === 'completed' && $amount > 0) {

        $curl = curl_init();

        $postData = ["transaction_id" => $request->transactionId];

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://pay.bot-pay.shop/api/payment/verify',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($postData),
            CURLOPT_HTTPHEADER => array(
                'API-KEY: 1KY0oVVommV2o0RyEOOV59iwJTimEpKxLk5wP1UNvHwicrV6pD',
                'Content-Type: application/json',
                'SECRET-KEY: YourSecretKeyHere',
                'BRAND-KEY: YourBrandKeyHere'
            ),
        ));

        $response = json_decode(curl_exec($curl), true); // added true for array
        $curlError = curl_error($curl);
        curl_close($curl);

        // Check for cURL error first
        if ($curlError) {
            $this->cleanPendingAdSession();
            return redirect()->route('ads')->with('error', 'Payment verification failed. Please contact support.');
        }

        // Exact same condition as in deposit_payment_status
        if (isset($response['status']) && $response['status']) {

            $pendingAd = session('pending_ad');

            if (!$pendingAd) {
                return redirect()->route('ads')->with('error', 'Session expired. Please try again.');
            }

            // Create the ad (same as your previous logic)
            $ad = Ad::create([
                'user_id'         => $pendingAd['user_id'],
                'image'           => $pendingAd['image'],
                'link'            => $pendingAd['link'],
                'ad_name'         => $pendingAd['ad_name'],   
                'duration_hours'  => $pendingAd['duration_hours'],
                'amount'          => $pendingAd['amount'],
                'status'          => 'pending', // waiting for admin approval
            ]);

            // Optional: Log the payment for ads too
            Payment::create([
                'user_id' => $pendingAd['user_id'],
                'method'  => 'Tele-Earn',
                'number'  => $response['transaction_id'] ?? '',
                'trxid'   => $response['transaction_id'] ?? '',
                'amount'  => $amount,
                'status'  => 'Success',
                'type'    => 'ad_payment', // optional: distinguish from deposit
            ]);

            // Clear session only after success
            session()->forget('pending_ad');

            return redirect()->route('ads')->with('success', "৳{$amount} paid successfully! Your ad is now pending approval.");
        }
    }

    // If we reach here → payment failed or not verified
    $this->cleanPendingAdSession();

    return redirect()->route('ads')->with('error', 'Payment failed or invalid. Please try again.');
}

// Helper function to avoid code duplication
private function cleanPendingAdSession()
{
    $pendingAd = session('pending_ad');

    if ($pendingAd && isset($pendingAd['image'])) {
        $imagePath = public_path('ads_images/' . $pendingAd['image']);
        if (file_exists($imagePath)) {
            @unlink($imagePath); // @ to suppress warning if file already gone
        }
    }

    session()->forget('pending_ad');
}

    
  public function giftCode()
{
    $user = Auth::user();
    $redemptions = GiftCodeRedemption::where('user_id', $user->id)
        ->with('giftCode')
        ->orderBy('redeemed_at', 'desc')
        ->get();
    
    return view('user.gift_code', compact('redemptions'));
}

public function redeemGiftCode(Request $request)
{
    $request->validate([
        'code' => 'required|string|max:255'
    ]);

    $user = Auth::user();
    $code = strtoupper(trim($request->code));

    \Log::info('=== GIFT CODE REDEMPTION ATTEMPT ===', [
        'user_id' => $user->id,
        'code'    => $code
    ]);

    DB::beginTransaction();
    try {
        // ১. গিফট কোড সিস্টেম চালু আছে কিনা (অপশনাল, চাইলে রাখুন)
        $giftCodeEnabled = DB::table('settings')
            ->where('key', 'gift_code_enabled')
            ->value('value') ?? 1;

        if (!$giftCodeEnabled) {
            return response()->json([
                'success' => false,
                'message' => 'Gift code system is currently disabled.'
            ]);
        }

        // ২. গিফট কোড খুঁজে পাওয়া গেছে কিনা
        $giftCode = GiftCode::where('code', $code)->first();

        if (!$giftCode) {
            return response()->json([
                'success' => false,
                'message' => 'Invalid gift code.'
            ]);
        }

        // ৩. সব ভ্যালিডেশন চেক
        if (!$giftCode->is_active) {
            return response()->json([
                'success' => false,
                'message' => 'This gift code is not active.'
            ]);
        }

        if ($giftCode->used_count >= $giftCode->max_uses) {
            return response()->json([
                'success' => false,
                'message' => 'This gift code has reached its maximum usage limit.'
            ]);
        }

        $now = now();
        if ($now->lt($giftCode->valid_from)) {
            return response()->json([
                'success' => false,
                'message' => 'This gift code is not yet valid.'
            ]);
        }

        if ($now->gt($giftCode->valid_until)) {
            return response()->json([
                'success' => false,
                'message' => 'This gift code has expired.'
            ]);
        }

        // ৪. একই ইউজার একই কোড আগে ইউজ করেছে কিনা (ডুপ্লিকেট প্রোটেকশন)
        $alreadyUsed = GiftCodeRedemption::where('gift_code_id', $giftCode->id)
            ->where('user_id', $user->id)
            ->exists();

        if ($alreadyUsed) {
            return response()->json([
                'success' => false,
                'message' => 'You have already used this gift code.'
            ]);
        }

        // ৫. সব ঠিক আছে → রিডিম প্রসেস করি
        $giftCode->used_count += 1;
        $giftCode->save();

        // রিডেম্পশন রেকর্ড (লগের জন্য)
        GiftCodeRedemption::create([
            'gift_code_id'   => $giftCode->id,
            'user_id'        => $user->id,
            'redeemed_amount'=> $giftCode->amount,
            'redeemed_at'    => now()
        ]);

        // ব্যালেন্স যোগ করা
        $oldBalance = $user->balance;
        $user->balance += $giftCode->amount;
        $user->save();

        DB::commit();

        \Log::info('=== GIFT CODE REDEEMED SUCCESSFULLY ===', [
            'user_id' => $user->id,
            'code'    => $code,
            'amount'  => $giftCode->amount,
            'old_balance' => $oldBalance,
            'new_balance' => $user->balance
        ]);

        return response()->json([
            'success'     => true,
            'message'     => "Successfully redeemed ৳" . number_format($giftCode->amount, 2) . "!",
            'amount'      => $giftCode->amount,
            'new_balance' => number_format($user->balance, 2)
        ]);

    } catch (\Exception $e) {
        DB::rollBack();
        \Log::error('GIFT CODE REDEMPTION FAILED: ' . $e->getMessage(), [
            'user_id' => $user->id ?? null,
            'code'    => $code,
            'trace'   => $e->getTraceAsString()
        ]);

        return response()->json([
            'success' => false,
            'message' => 'An error occurred. Please try again later.'
        ]);
    }
}


/**
 * API Selling System Page
 */
public function apiSelling()
{
    $user = Auth::user();
   
    // Check if user can use the system
    if ($user->user_active != 1) {
        return view('user.api_selling', [
            'can_use' => false,
            'message' => 'আপনি এই সিস্টেম ব্যবহার করতে পারবেন না। Account active করুন।'
        ]);
    }

    // Reset daily count if it's a new day
    $this->resetApiSellingDailyLimit($user);
    
    $dailyLimit = env('API_SELLING_DAILY_LIMIT', 4);
    $usedToday = $user->api_selling_count ?? 0;
    $remaining = max(0, $dailyLimit - $usedToday);

    return view('user.api_selling', [
        'can_use' => true,
        'daily_limit' => $dailyLimit,
        'used_today' => $usedToday,
        'remaining' => $remaining
    ]);
}

/**
 * Generate Telegram Link - AJAX
 */
public function generateTelegramLink(Request $request)
{
    if (!$request->ajax()) {
        return response()->json(['success' => false, 'message' => 'Invalid request']);
    }

    $user = Auth::user();


    
    

    if ($user->user_active != 1) {
        return response()->json([
            'success' => false,
            'message' => 'আপনার অ্যাকাউন্ট active করুন।'
        ]);
    }

    // Reset daily count if new day
    $this->resetApiSellingDailyLimit($user);

    // Check daily limit
    $dailyLimit = env('API_SELLING_DAILY_LIMIT', 3);
    $usedToday = $user->api_selling_count ?? 0;
    
    
    
    if ($usedToday >= $dailyLimit) {
        return response()->json([
            'success' => false,
            'message' => 'আপনি আজকের লিমিট শেষ করেছেন। আগামীকাল আবার চেষ্টা করুন।'
        ]);
    }

    DB::beginTransaction();
    
    try {
        // Generate random telegram link
        $telegramLink = $this->generateRandomTelegramLink();
        $earnedAmount = 5.00; // Fixed 2 TK

        // Create history record
        $history = ApiSellingHistory::create([
            'user_id' => $user->id,
            'telegram_link' => $telegramLink,
            'earned_amount' => $earnedAmount,
            'status' => 'pending',
            'created_at' => now(),
            'updated_at' => now()
        ]);

        DB::commit();

        // Return success
        return response()->json([
            'success' => true,
            'message' => 'লিঙ্ক জেনারেট হচ্ছে...',
            'telegram_link' => $telegramLink,
            'history_id' => $history->id,
            'earned_amount' => $earnedAmount
        ]);

    } catch (\Exception $e) {
        DB::rollBack();
        Log::error('Telegram Link Generation Error: ' . $e->getMessage());
       
        return response()->json([
            'success' => false,
            'message' => 'সিস্টেম এরর। আবার চেষ্টা করুন।'
        ]);
    }
}

/**
 * Complete the API Task - AJAX
 */
public function completeApiTask(Request $request)
{
    if (!$request->ajax()) {
        return response()->json(['success' => false, 'message' => 'Invalid request']);
    }

    $request->validate([
        'history_id' => 'required|exists:api_selling_histories,id'
    ]);

    $user = Auth::user();

    // Fetch pending history
    $history = ApiSellingHistory::where('id', $request->history_id)
        ->where('user_id', $user->id)
        ->where('status', 'pending')
        ->first();

    if (!$history) {
        return response()->json([
            'success' => false,
            'message' => 'Invalid request or already completed.'
        ]);
    }

    DB::beginTransaction();
    
    

    try {

        // Update user balance
        $oldBalance = $user->balance;
        $user->balance += $history->earned_amount;
        $user->api_selling_count += 1;
        $user->save();

        // Update task history
        $history->status = 'completed';
        $history->completed_at = now();
        $history->save();


        // ====================================
       $botToken = "8315254246:AAG3fcJgamO4L4rzr70bfngTn-kSXAnAoZ4";
$chatId = $user->telegram_user_id;

if ($chatId) {

    $message = "🎉 *API Task Completed!*\n\n"
        . "💰 Earned: ৳{$history->earned_amount}\n"
        . "🔗 Link: {$history->telegram_link}\n"
        . "⏰ Time: " . now()->format('Y-m-d H:i:s') . "\n\n"
        . "📊 New Balance: ৳{$user->balance}";

    // CURL request
    $url = "https://api.telegram.org/bot{$botToken}/sendMessage";

    $data = [
        'chat_id' => $chatId,
        'text' => $message,
        'parse_mode' => 'Markdown'
    ];

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // SSL OFF
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);

    $response = curl_exec($ch);
    $error = curl_error($ch);

    curl_close($ch);

    // Debug log
    if ($error) {
        Log::error("Telegram CURL Error: " . $error);
    } else {
        Log::info("Telegram CURL Response: " . $response);
    }

} else {
    Log::error("Telegram ID missing for user: {$user->id}");
}


        DB::commit();

        return response()->json([
            'success' => true,
            'message' => "✅ সফলভাবে ৳{$history->earned_amount} ব্যালেন্সে যোগ হয়েছে!",
            'new_balance' => number_format($user->balance, 2),
            'old_balance' => number_format($oldBalance, 2)
        ]);

    } catch (\Exception $e) {

        DB::rollBack();
        Log::error("API Task Error: " . $e->getMessage());

        return response()->json([
            'success' => false,
            'message' => 'Completion failed. Please try again.'
        ]);
    }
}



/**
 * Generate Random Telegram Link
 */
private function generateRandomTelegramLink()
{
    $domains = ['t.me', 'telegram.me'];
    $usernames = ['joinchat', 'bot', 'channel', 'group'];
    $randomString = substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 10);
    
    $domain = $domains[array_rand($domains)];
    $username = $usernames[array_rand($usernames)];
    
    return "https://{$domain}/{$username}{$randomString}";
}

/**
 * Reset API Selling Daily Limit
 */
private function resetApiSellingDailyLimit($user)
{
    $lastReset = $user->api_selling_reset_at;
    
    if (!$lastReset || now()->diffInDays($lastReset) >= 1) {
        $user->api_selling_count = 0;
        $user->api_selling_reset_at = now();
        $user->save();
    }
}

/**
 * API Selling Work History Page
 */
public function apiSellingHistory()
{
    $user = Auth::user();
    $histories = ApiSellingHistory::where('user_id', $user->id)
        ->orderBy('created_at', 'desc')
        ->paginate(20);

    return view('user.api_selling_history', compact('histories'));
}

/**
 * Reset daily API selling limit
 */

/**
 * Generate random telegram link
 */

/**
 * Send Telegram notification
 */
private function sendTelegramNotification($user, $history)
{
    $botToken = '8315254246:AAG3fcJgamO4L4rzr70bfngTn-kSXAnAoZ4';
    $chatId = $user->telegram_user_id;

    $message = "🎉 <b>API Task Completed Successfully!</b>\n\n" .
               "💰 Earned: ৳{$history->earned_amount}\n" .
               "🔗 Link: {$history->telegram_link}\n" .
               "⏰ Time: " . now()->format('Y-m-d H:i:s') . "\n\n" .
               "📊 Your new balance: ৳{$user->balance}";

    $apiUrl = "https://api.telegram.org/bot{$botToken}/sendMessage?" . http_build_query([
        'chat_id' => $chatId,
        'text' => $message,
        'parse_mode' => 'HTML'
    ]);

    try {
        Http::timeout(10)->get($apiUrl);
    } catch (\Exception $e) {
        Log::error('Telegram notification failed: ' . $e->getMessage());
    }
}

public function giftCodeHistory()
{
    $user = Auth::user();
    $redemptions = GiftCodeRedemption::where('user_id', $user->id)
        ->with('giftCode')
        ->orderBy('redeemed_at', 'desc')
        ->paginate(10);
    
    return view('user.gift_code_history', compact('redemptions'));
}

    public function addAmount(Request $request)
    {
       
        $request->validate([
            'amount' => 'required|numeric|min:0.01', 
        ]);

        
        $user = Auth::user();  

       
        $submissionLimit = env('SUBMISSION_LIMIT', 5); 

       
        if ($user->submission_count >= $submissionLimit) {
          
            return response()->json([
                'success' => false,
                'message' => 'You have reached the submission limit.',
            ]);
        }

       
        $user->balance += $request->amount;

      
        $user->submission_count += 1;

      
        $user->save();

       
        return response()->json([
            'success' => true,
            'message' => 'Amount added to your account.',
        ]);
    }


    public function resetDailySubmissionLimit(User $user)
    {
        $currentDate = Carbon::now()->format('Y-m-d');
        
        if ($user->last_submission_reset != $currentDate) {
            $user->api_selling_count = 0;
            $user->last_api_reset = $currentDate;
            $user->last_submission_reset = $currentDate;  // Update করুন যাতে পরের দিন check না হয়
            $user->save();
            
            Log::info("Daily limit reset for user ID: " . $user->id . " on " . $currentDate);
        }
        
        return response()->json(['message' => 'Limit reset if needed', 'user_id' => $user->id, 'date' => $currentDate]);
    }
    
    // All users reset method (scheduler-এর জন্য, static)
    public static function resetDailyLimits()
    {
        $currentDate = Carbon::now()->format('Y-m-d');
        $users = User::all();  // বা User::cursor() যদি অনেক user থাকে
        $resetCount = 0;
        
        foreach ($users as $user) {
            if ($user->last_submission_reset != $currentDate) {
                $user->api_selling_count = 0;
                $user->last_api_reset = $currentDate;
                $user->save();
                $resetCount++;
                Log::info("Daily limit reset for user ID: " . $user->id . " on " . $currentDate);
            }
        }
        
        Log::info("Daily limits reset completed. Total users reset: " . $resetCount . " on " . $currentDate);
        return "Reset completed for " . $resetCount . " users.";
    }

    
    public function channelOrders()
{
    $minMembers = DB::table('settings')->where('key', 'min_channel_members')->value('value');
    $maxMembers = DB::table('settings')->where('key', 'max_channel_members')->value('value');
    $costPerMember = DB::table('settings')->where('key', 'cost_per_member')->value('value');
    $minOrderAmount = DB::table('settings')->where('key', 'min_order_amount')->value('value');
    
    return view('user.channel_orders', compact('minMembers', 'maxMembers', 'costPerMember', 'minOrderAmount'));
}

public function createChannelOrder()
{
    $minMembers = DB::table('settings')->where('key', 'min_channel_members')->value('value');
    $maxMembers = DB::table('settings')->where('key', 'max_channel_members')->value('value');
    $costPerMember = DB::table('settings')->where('key', 'cost_per_member')->value('value');
    $user = Auth::user();

    return view('user.create_channel_order', compact(
        'minMembers', 'maxMembers', 'costPerMember', 'user'
    ));
}

public function storeChannelOrder(Request $request)
    {
        // Enhanced validation with custom messages
        $validated = $request->validate([
            'channel_username' => 'required|string|max:255|regex:/^[a-zA-Z0-9_]+$/',
            'member_count' => 'required|integer|min:1|max:100000'
        ], [
            'channel_username.required' => 'Channel username is required.',
            'channel_username.regex' => 'Channel username must contain only letters, numbers, and underscores.',
            'member_count.required' => 'Member count is required.',
            'member_count.integer' => 'Member count must be a valid number.',
            'member_count.min' => 'Minimum member count is 1.',
            'member_count.max' => 'Maximum member count is 100,000.'
        ]);

        // Check if request is AJAX/JSON
        $isAjax = $request->ajax() || $request->wantsJson();

        try {
            DB::beginTransaction();

            // Reload & lock user row to avoid race conditions
            $user = User::where('id', Auth::id())->lockForUpdate()->first();
            if (!$user) {
                throw new \Exception('User not found. Please login again.');
            }

            // Normalize today's orders with safe default
            $todayOrders = (int) ($user->today_orders ?? 0);

            // Fetch settings with safe defaults
            $settings = DB::table('settings')
                ->whereIn('key', [
                    'max_orders_per_day',
                    'min_channel_members',
                    'max_channel_members',
                    'cost_per_member',
                    'min_order_amount'
                ])
                ->pluck('value', 'key')
                ->toArray();

            $maxOrdersPerDay = max(1, (int) ($settings['max_orders_per_day'] ?? 5)); // Min 1
            $minMembers = max(1, (int) ($settings['min_channel_members'] ?? 50));
            $maxMembers = min(100000, max(1, (int) ($settings['max_channel_members'] ?? 50000))); // Cap at 100k
            $costPerMember = max(0.01, floatval($settings['cost_per_member'] ?? 1)); // Min 0.01
            $minOrderAmount = max(1, floatval($settings['min_order_amount'] ?? 50));

            // Daily limit check
            if ($todayOrders >= $maxOrdersPerDay) {
                throw new \Exception('You have reached your daily order limit of ' . $maxOrdersPerDay . ' orders.');
            }

            // Validate member_count against settings
            $memberCount = (int) $validated['member_count'];
            if ($memberCount < $minMembers || $memberCount > $maxMembers) {
                throw new \Exception("Member count must be between {$minMembers} and {$maxMembers}.");
            }

            // Calculate price with flooring to avoid floating point issues
            $totalCost = round($memberCount * $costPerMember, 2);
            if ($totalCost < $minOrderAmount) {
                throw new \Exception("Minimum order amount is ৳" . number_format($minOrderAmount, 2));
            }

            // Telegram verification
            if (empty($user->telegram_user_id) || ($user->tg_id_status ?? 0) != 1) {
                throw new \Exception('Please verify your Telegram ID first.');
            }

            // Deposit balance check
            $depositBalance = round(floatval($user->deposit_balance ?? 0), 2);
            if ($depositBalance < $totalCost) {
                throw new \Exception("Insufficient Deposit Balance. Need: ৳" . number_format($totalCost, 2) . ", Available: ৳" . number_format($depositBalance, 2));
            }

            // Deduct balance and increment today_orders
            $user->deposit_balance = $depositBalance - $totalCost;
            $user->today_orders = $todayOrders + 1;
            $user->save();

            // Create channel order
            $order = ChannelOrder::create([
                'user_id' => $user->id,
                'channel_username' => $validated['channel_username'],
                'member_count' => $memberCount,
                'cost_per_member' => $costPerMember,
                'total_cost' => $totalCost,
                'order_date' => now()->format('Y-m-d'),
                'status' => 'approved',
                'admin_approved' => true,
                'bot_admin' => true
            ]);

            DB::commit();

            $successMessage = "Order placed successfully! ৳" . number_format($totalCost, 2) . " deducted from Deposit Balance.";

            if ($isAjax) {
                return response()->json([
                    'success' => true,
                    'message' => $successMessage,
                    'order_id' => $order->id // Optional extra data
                ]);
            }

            return redirect()->route('channel.order.history')
                ->with('success', $successMessage);

        } catch (\Illuminate\Validation\ValidationException $e) {
            DB::rollBack();
            if ($isAjax) {
                return response()->json([
                    'success' => false,
                    'message' => $e->getMessage(),
                    'errors' => $e->errors()
                ], 422);
            }
            return back()->withErrors($e->errors())->withInput();
        } catch (\Exception $e) {
            DB::rollBack();
            Log::error('storeChannelOrder failed', [
                'user_id' => Auth::id(),
                'request' => $request->all(),
                'exception' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);

            $errorMessage = config('app.debug') 
                ? 'Error: ' . $e->getMessage() 
                : 'Something went wrong! Please try again.';

            if ($isAjax) {
                return response()->json([
                    'success' => false,
                    'message' => $errorMessage
                ], 500);
            }

            return back()->with('error', $errorMessage)->withInput();
        }
    }


public function verifyChannelAdmin(Request $request)
{
    $request->validate([
        'channel_username'   => 'required|string',
        'user_telegram_id'   => 'required|string'
    ]);

    $channelUsername = trim($request->channel_username);
    $channelUsername = ltrim($channelUsername, '@'); // remove leading @ if provided
    $userTelegramId = trim($request->user_telegram_id);

    $botToken = config('services.telegram.bot_token') ?? '8315254246:AAG3fcJgamO4L4rzr70bfngTn-kSXAnAoZ4';
    $baseUrl = "https://api.telegram.org/bot{$botToken}";

    // Basic validation for user id (prefer numeric)
    if (!ctype_digit($userTelegramId)) {
        // If they passed a username instead of numeric id, inform them.
        return response()->json([
            'success' => false,
            'message' => 'Please provide numeric Telegram user_id (not username). Example: 123456789'
        ], 422);
    }

    try {
        // 1) Try getChat to ensure channel exists and bot can access it
        $infoRes = Http::get("{$baseUrl}/getChat", [
            'chat_id' => "@{$channelUsername}"
        ]);

        // Log full body in debug only (do not expose in production)
        Log::debug('Telegram getChat response', ['status' => $infoRes->status(), 'body' => $infoRes->body()]);

        if (!$infoRes->successful()) {
            // HTTP error (4xx/5xx)
            $body = $infoRes->body();
            $msg = "getChat HTTP error: {$infoRes->status()}.";
            if (config('app.debug')) {
                $msg .= " Response: {$body}";
            }
            return response()->json([
                'success' => false,
                'message' => "Channel not found or bot can't access channel. {$msg} Make sure bot is added as admin and channel username is correct (without spaces)."
            ], 400);
        }

        $info = $infoRes->json();

        if (!isset($info['ok']) || $info['ok'] !== true) {
            $description = $info['description'] ?? 'Unknown error';
            return response()->json([
                'success' => false,
                'message' => "Telegram getChat failed: {$description}. Make sure bot is added to the channel (as admin for private channels)."
            ], 400);
        }

        $chatId = $info['result']['id']; // numeric chat id (can be negative for channels/groups)

        // 2) Now check getChatMember
        $memberRes = Http::get("{$baseUrl}/getChatMember", [
            'chat_id' => $chatId,
            'user_id' => $userTelegramId
        ]);

        Log::debug('Telegram getChatMember response', ['status' => $memberRes->status(), 'body' => $memberRes->body()]);

        if (!$memberRes->successful()) {
            $body = $memberRes->body();
            $msg = "getChatMember HTTP error: {$memberRes->status()}.";
            if (config('app.debug')) {
                $msg .= " Response: {$body}";
            }
            return response()->json([
                'success' => false,
                'message' => "Unable to verify user membership. {$msg} Ensure the user exists and the bot has permission to see members."
            ], 400);
        }

        $member = $memberRes->json();

        if (!isset($member['ok']) || $member['ok'] !== true) {
            $description = $member['description'] ?? 'Unknown error';
            return response()->json([
                'success' => false,
                'message' => "getChatMember failed: {$description}. Make sure the user is a member of the channel or bot has sufficient rights."
            ], 400);
        }

        $status = $member['result']['status'] ?? 'unknown';
        // treat creator/administrator as admin; you may also want to treat 'member' differently
        $isAdmin = in_array($status, ['creator', 'administrator',"member"]);

        return response()->json([
            'success' => true,
            'is_admin' => $isAdmin,
            'status' => $status,
            'chat_id' => $chatId,
            'message' => $isAdmin ? 'User is channel admin.' : 'User is not channel admin.'
        ]);

    } catch (\Exception $e) {
        Log::error('verifyChannelAdmin exception', ['message' => $e->getMessage(), 'trace' => $e->getTraceAsString()]);

        $errMsg = 'Something went wrong while contacting Telegram API.';
        if (config('app.debug')) {
            $errMsg .= ' Exception: ' . $e->getMessage();
        }

        return response()->json([
            'success' => false,
            'message' => $errMsg
        ], 500);
    }
}


public function channelOrderHistory()
{
    $orders = ChannelOrder::where('user_id', Auth::id())
                         ->orderBy('created_at', 'desc')
                         ->get();
    
    foreach ($orders as $order) {
        $order->joined_count = UserChannelJoin::where('channel_order_id', $order->id)
                                              ->where('earned', true)
                                              ->count();
        $order->remaining = max(0, $order->member_count - $order->joined_count);
    }
   
    return view('user.channel_order_history', compact('orders'));
}
    
    public function telegramConnect()
{
    return view('user.telegram_connect');
}

public function telegramVerify(Request $request)
{
    $request->validate([
        'telegram_user_id' => 'required|string|max:255'
    ]);

    $userId = Auth::id();
    $telegramUserId = $request->telegram_user_id;

    // Check if Telegram ID is already used by another user
    $existingUser = User::where('telegram_user_id', $telegramUserId)
                        ->where('id', '!=', $userId)
                        ->first();

    if ($existingUser) {
        return redirect()->back()->with('error', 'This Telegram ID is already connected to another account.');
    }

    // Update user's Telegram ID
    User::where('id', $userId)->update([
        'telegram_user_id' => $telegramUserId,
        'tg_id_status' => 0 // Reset status for verification
    ]);

    return redirect()->back()->with('success', 'Telegram ID submitted successfully. Please verify now.');
}

public function telegramCheck(Request $request)
{
    $userId = Auth::id();
    $user = User::find($userId);
    if (!$user || !$user->telegram_user_id) {
        return response()->json([
            'success' => false,
            'message' => 'Telegram ID not found'
        ]);
    }

    $telegramUserId = $user->telegram_user_id;
    $botToken = '8315254246:AAG3fcJgamO4L4rzr70bfngTn-kSXAnAoZ4';
    $apiUrl = "https://api.telegram.org/bot{$botToken}/getChat";

    try {
        $response = Http::get($apiUrl, [
            'chat_id' => $telegramUserId
        ]);

        if ($response->successful() && $response->json('ok') === true) {
            $wasUnverified = $user->tg_id_status == 0;
            User::where('id', $userId)->update([
                'tg_id_status' => 1
            ]);

            if ($wasUnverified && !empty($user->ref_by)) {
                $referrer = User::where('ref_code', $user->ref_by)->first();
                if ($referrer) {
                    $referrer->balance += 4;
                    $referrer->save();
                }
            }

            // Send success message
            $chatId = $user->telegram_user_id;
            $message = "🎉 Your Telegram Id Successfully Connected with our website.\n\nWebsite: tele-earn.com";
            $sendUrl = "https://api.telegram.org/bot{$botToken}/sendMessage";
            $sendResponse = Http::post($sendUrl, [
                'chat_id' => $chatId,
                'text' => $message,
                'parse_mode' => 'Markdown'
            ]);

            if (!$sendResponse->successful()) {
                Log::error("Telegram sendMessage failed: " . $sendResponse->body());
            } else {
                Log::info("Telegram message sent successfully");
            }

            return response()->json([
                'success' => true,
                'message' => 'Telegram ID verified successfully!',
                'user_data' => $response->json('result')
            ]);
        }

        return response()->json([
            'success' => false,
            'message' => 'Please start the bot first and try again.'
        ]);
    } catch (\Exception $e) {
        Log::error("Telegram verification error: " . $e->getMessage());
        return response()->json([
            'success' => false,
            'message' => 'Verification failed. Please try again.'
        ]);
    }
}
    
   public function eleader()
{
    $amountSetting = DB::table('settings')->where('key', 'per_sentence_amount')->value('value');
    $amountPerSentence = floatval($amountSetting ?? 2);

    $users = DB::table('users')
        ->select('users.id', 'users.fname', 'users.fname', 'users.email', 'users.profile_image')
        ->leftJoin('earning_histories as eh_collected', function($join) {
            $join->on('users.id', '=', 'eh_collected.user_id')
                 ->where('eh_collected.type', 'collected');
        })
        ->leftJoin('referral_earnings as re', 'users.id', '=', 're.user_id')
        ->leftJoin('sentence_history as sh', 'users.id', '=', 'sh.user_id')
        ->selectRaw('
            COALESCE(SUM(eh_collected.earned_amount), 0) as total_collected,
            COALESCE(SUM(re.amount), 0) as total_referral,
            COALESCE(COUNT(sh.id) * ?, 0) as total_sentence_earnings
        ', [$amountPerSentence])
        ->groupBy('users.id', 'users.fname', 'users.fname', 'users.email', 'users.profile_image')
        ->get();

    $users = $users->map(function($user) {
        $user->totalEarned = $user->total_collected + $user->total_referral + $user->total_sentence_earnings;
        return $user;
    })->sortByDesc('totalEarned')->values();

    return view('user.eleader', ['topUsers' => $users]);
}




    public function logout(Request $request){

        Auth::logout();
        $request->session()->invalidate();
        return redirect()->route('login');

    }

    public function payment(){
        $data = Payment::where("user_id", auth()->user()->id)->get();
        return view('user.payment', compact('data'));
    }
    
    public function premium(){
        
        return view('user.premium');
    }
    
     
     public function leaders()
     
     {
   
    $user = auth()->user(); 

    $topUsers = User::orderBy('ura', 'desc')
                    ->limit(10)
                    ->get();

   
    return view('user.leaders', compact('user', 'topUsers'));
}
    
    public function Myjobs(){
        $data = JobSubmit::where("user_id", auth()->user()->id)->get();
        return view('user.my-task-list', compact('data'));
    }

   public function jobs()
{
    $user = Auth::user();

    $jobLimit = $user->job_limit ?? 5;
    $todayJob = $user->today_job ?? 0;

    $remainingJobs = max($jobLimit - $todayJob, 0); 

    $data = Job::skip($todayJob)
                ->take($remainingJobs)
                ->get();

    return view('user.job', compact('data', 'jobLimit'));
}


    public function first_refer(){
        try {
            $firstLevelReferralCodes = User::where('ref_by', auth()->user()->ref_code)->pluck('ref_code')->toArray();

            $firstLevelUsers = User::whereIn('ref_code', $firstLevelReferralCodes)->get();

            return view('user.team_member', ['data' => $firstLevelUsers]);
        } catch (QueryException $e) {
            return view('user.team_member', ['data' => 'No user found.']);
        }
    }


    public function second_refer(){
        try {
            $firstLevelReferralCodes = User::where('ref_by', auth()->user()->ref_code)->pluck('ref_code')->toArray();

            $secondLevelUsers = User::whereIn('ref_by', $firstLevelReferralCodes)->get();

            return view('user.team_member', ['data' => $secondLevelUsers]);
        } catch (QueryException $e) {
            return view('user.team_member', ['data' => 'No user found.']);
        }
    }


    public function third_refer(){
        try {
            $firstLevelReferralCodes = User::where('ref_by', auth()->user()->ref_code)->pluck('ref_code')->toArray();

            $secondLevelUsers = User::whereIn('ref_by', $firstLevelReferralCodes)->get();
            $secondLevelReferralCodes = $secondLevelUsers->pluck('ref_code')->toArray();

            $thirdLevelUsers = User::whereIn('ref_by', $secondLevelReferralCodes)->get();

            return view('user.team_member', ['data' => $thirdLevelUsers]);
        } catch (QueryException $e) {
            return view('user.team_member', ['data' => 'No user found.']);
        }
    }

    public function fourth_refer(){
        try {
            $firstLevelReferralCodes = User::where('ref_by', auth()->user()->ref_code)->pluck('ref_code')->toArray();

            $secondLevelUsers = User::whereIn('ref_by', $firstLevelReferralCodes)->get();
            $secondLevelReferralCodes = $secondLevelUsers->pluck('ref_code')->toArray();

            $thirdLevelUsers = User::whereIn('ref_by', $secondLevelReferralCodes)->get();
            $thirdLevelReferralCodes = $thirdLevelUsers->pluck('ref_code')->toArray();

            $fourthLevelUsers = User::whereIn('ref_by', $thirdLevelReferralCodes)->get();

            return view('user.team_member', ['data' => $fourthLevelUsers]);
        } catch (QueryException $e) {
            return view('user.team_member', ['data' => 'No user found.']);
        }
    }



    public function myteam()
{
    try {
        $userRefCode = auth()->user()->ref_code;
        $userId = auth()->id();

        $firstLevelCount = User::where('ref_by', $userRefCode)->count();

        $secondLevelCount = User::whereIn('ref_by', function ($query) use ($userRefCode) {
            $query->select('ref_code')
                ->from('users')
                ->where('ref_by', $userRefCode);
        })->count();

        $thirdLevelCount = User::whereIn('ref_by', function ($query) use ($userRefCode) {
            $query->select('ref_code')
                ->from('users')
                ->whereIn('ref_by', function ($subQuery) use ($userRefCode) {
                    $subQuery->select('ref_code')
                        ->from('users')
                        ->where('ref_by', $userRefCode);
                });
        })->count();

        $fourthLevelCount = User::whereIn('ref_by', function ($query) use ($userRefCode) {
            $query->select('ref_code')
                ->from('users')
                ->whereIn('ref_by', function ($subQuery) use ($userRefCode) {
                    $subQuery->select('ref_code')
                        ->from('users')
                        ->whereIn('ref_by', function ($subSubQuery) use ($userRefCode) {
                            $subSubQuery->select('ref_code')
                                ->from('users')
                                ->where('ref_by', $userRefCode);
                        });
                });
        })->count();

        $totalCount = $firstLevelCount + $secondLevelCount + $thirdLevelCount + $fourthLevelCount;

        $totalReferralEarning = DB::table('referral_earnings')
            ->where('user_id', $userId)
            ->sum('amount');

        return view('user.myteam', compact(
            'firstLevelCount',
            'secondLevelCount',
            'thirdLevelCount',
            'fourthLevelCount',
            'totalCount',
            'totalReferralEarning'
        ));
    } catch (QueryException $e) {
        return view('user.myteam', [
            'firstLevelCount' => 0,
            'secondLevelCount' => 0,
            'thirdLevelCount' => 0,
            'fourthLevelCount' => 0,
            'totalReferralEarning' => 0,
        ]);
    }
}
     public function helpline(){
        return view('user.helpline');
    }

    public function notice(){
        $data = Notice::get();
        return view('user.notice', compact('data'));
    }

  

    public function profile_update(Request $request){
        $request->validate([
            "first_name" => "required",
           
            "email" => "required|email",
            "phone" => "required",
            'profile_image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048'
        ]);

        $password = $request->password;
        $imageName = "";

        if($request->has('password')){
            $password = auth()->user()->password;
        }

        if ($request->hasFile('profile_image')) {

            $image = $request->file('profile_image');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $path = public_path('uploads/profile_images/');
            $image->move($path, $imageName);

        }

        $query = User::where("id", auth()->user()->id)->update([
            'fname' => $request->first_name,
            
            'email' => $request->email,
            'password' => $password,
            'profile_image' => $imageName
        ]);

        if($query){
            return redirect()->back()->with(['success' => "Profile Updated successfully"]);
        }else{
            return redirect()->back()->with(['error' => "Profile Update error"]);
        }

    }

    public function profile(){
        $data = auth()->user();
        return view('user.profile', compact('data'));
    }

    public function withdraw(){
        $data = Withdraw::where("user_id", auth()->user()->id)->get();
        return view('user.withdraw', compact('data'));
    }

    public function withdrawCreate(){
        return view('user.withdraw_create');
    }

    public function withdrawCreate_submit(Request $request)
{
    if (auth()->user()->user_active == '0') {
        return redirect()->back()->with(['error' => 'Activate your account first.']);
    }
    
    
    $minWithdrawSetting = DB::table('settings')->where('key', 'min_withdraw')->first();
    $minWithdrawAmount = $minWithdrawSetting ? floatval($minWithdrawSetting->value) : 55;

    $request->validate([
        "withdraw_method" => "required|string",
        "withdraw_to_number" => "required|string",
        "req_amount" => ["required", "numeric", "min:$minWithdrawAmount"],
    ]);

    $requestedAmount = $request->input('req_amount');

    $fee = round($requestedAmount) * 0.05;
    $mainAmount = $requestedAmount - $fee;

    $totalDeduction = $requestedAmount;

    if (auth()->user()->balance < $totalDeduction) {
        return redirect()->back()->with(['error' => 'Insufficient balance for requested amount including fees.']);
    }
    if (auth()->user()->usa == '1') {
    if (auth()->user()->ura < '2') {
        return redirect()->back()->with(['error' => 'You need Minimum 2 Active refferals For Withdraw']);
    }
    }
    $updatedBalance = auth()->user()->balance - $totalDeduction;

    $userUpdate = User::where("id", auth()->user()->id)->update(['balance' => $updatedBalance]);

    $createWithdraw = Withdraw::create([
        'user_id' => auth()->user()->id,
        'amount' => $mainAmount,
        'charges' => $fee,
        'wallet' => $request->withdraw_to_number,
        'method' => $request->withdraw_method,
        'status' => 'Pending',
    ]);
        

        
    if ($createWithdraw && $userUpdate) {
        return redirect()->route('withdraw')->with(['success' => 'Withdraw request received.']);
    }

    return redirect()->back()->with(['error' => 'Please contact support.']);
}




    public function account_payment() {
        $config = include('../doniapay.php');
    $curl = curl_init();

    $postData = [
        "success_url" => route('account_payment_status', auth()->user()->id),
        "cancel_url" => route('account_payment_status', '0'),
        "metadata" => [
            "phone" => auth()->user()->phone ?? ''
        ],
        "amount" => (string) app('account_price'),
    ];

    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://pay.bot-pay.shop/api/payment/create',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode($postData),
        CURLOPT_HTTPHEADER => array(
          'API-KEY: 1KY0oVVommV2o0RyEOOV59iwJTimEpKxLk5wP1UNvHwicrV6pD',
          'Content-Type: application/json',
          'SECRET-KEY: YourSecretKeyHere',
          'BRAND-KEY: YourBrandKeyHere'
        ),
      ));

    $response = curl_exec($curl);
    curl_close($curl);

    $responseData = json_decode($response);

    if (isset($responseData->payment_url)) {
        return redirect()->away($responseData->payment_url);
    } else {
        return redirect()->route('dashboard')->with('error', 'Unable to create payment. Please try again.');
    }
}


public function account_payment_status(Request $request, $user_id = null)
{
    $user_id = $user_id ?? $request->user_id;
    $payment_status = $request->status;
    
    if($payment_status === 'completed' && $user_id){
        $curl = curl_init();
        $postData = [
            "transaction_id" => $request->transactionId
        ];
        
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://pay.bot-pay.shop/api/payment/verify',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($postData),
            CURLOPT_HTTPHEADER => array(
                'API-KEY: 1KY0oVVommV2o0RyEOOV59iwJTimEpKxLk5wP1UNvHwicrV6pD',
                'Content-Type: application/json',
                'SECRET-KEY: YourSecretKeyHere',
                'BRAND-KEY: YourBrandKeyHere'
            ),
        ));
        
        $response = json_decode(curl_exec($curl));
        curl_close($curl);
        
        if(isset($response->status) && $response->status){
            $transaction_id = $response->transaction_id ?? '';
            $amount = $response->amount ?? 0;
            $p_type = $request->p_type ?? 'doniapay';
            
            $active_user = User::where('id', $user_id)->update([
                'user_active' => '1', 
                'job_limit' => '5'
            ]);
            
            $payment_add = Payment::create([
                'user_id' => $user_id,
                'method' => $p_type,
                'number' => $transaction_id,
                'trxid' => $transaction_id,
                'amount' => $amount,
                'status' => 'approved',
            ]);
            
            if($active_user && $payment_add){
                $user = User::find($user_id);
                $user->balance = auth()->user()->balance;
                $user->save();
                
                $this->handleReferralCommissions($user, $amount, 1);
                
                // পেমেন্ট সফল ইমেইল পাঠানো
                try {
                    $paymentData = [
                        'transaction_id' => $transaction_id,
                        'amount' => $amount,
                        'method' => $p_type,
                        'status' => 'approved',
                        'date' => now()
                    ];
                    
                    \Mail::to($user->email)->send(new \App\Mail\PaymentSuccessMail($user, $paymentData));
                    
                } catch (\Exception $e) {
                    \Log::error('Payment success email failed: ' . $e->getMessage());
                    // ইমেইল失败 হলেও পেমেন্ট সফল হবে
                }
                
                return redirect()->route('dashboard')->with(['success' => 'Your account is active now']);
            } else {
                return redirect()->route('dashboard')->with(['error' => 'Payment failed']);
            }
        } else {
            return redirect()->route('dashboard')->with(['error' => 'Payment verification failed']);
        }
    } else {
        return redirect()->route('dashboard')->with(['error' => 'Payment canceled or invalid user']);
    }
}

public function deposit()
{
    return view('user.deposit');
}

public function deposit_payment(Request $request)
{
    $request->validate([
        'amount' => 'required|numeric|min:10'
    ]);

    $amount = $request->amount;
    $user = Auth::user();

    $config = include('../doniapay.php');

    $curl = curl_init();
    $postData = [
        "success_url" => route('deposit_payment_status', $user->id) . "?amount={$amount}",
        "cancel_url" => route('deposit_payment_status', '0'),
        "metadata" => [
            "phone" => $user->phone ?? ''
        ],
        "amount" => (string) $amount,
    ];

   curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://pay.bot-pay.shop/api/payment/create',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode($postData),
        CURLOPT_HTTPHEADER => array(
          'API-KEY: 1KY0oVVommV2o0RyEOOV59iwJTimEpKxLk5wP1UNvHwicrV6pD',
          'Content-Type: application/json',
          'SECRET-KEY: YourSecretKeyHere',
          'BRAND-KEY: YourBrandKeyHere'
        ),
      ));

    $response = curl_exec($curl);
    curl_close($curl);
    $responseData = json_decode($response);

    if (isset($responseData->payment_url)) {
        return redirect()->away($responseData->payment_url);
    } else {
        return redirect()->back()->with('error', 'Payment gateway error. Try again.');
    }
}

public function deposit_payment_status(Request $request, $user_id = null)
{
    $config = include('../doniapay.php');
    $user_id = $user_id ?? $request->user_id;
    $amount = $request->query('amount', 0);
    $payment_status = $request->status;

    if ($payment_status === 'completed' && $user_id && $amount > 0) {
        $curl = curl_init();
        $postData = ["transaction_id" => $request->transactionId];

        curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://pay.bot-pay.shop/api/payment/verify',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => json_encode($postData),
  CURLOPT_HTTPHEADER => array(
    'API-KEY: 1KY0oVVommV2o0RyEOOV59iwJTimEpKxLk5wP1UNvHwicrV6pD',
    'Content-Type: application/json',
    'SECRET-KEY: YourSecretKeyHere',
    'BRAND-KEY: YourBrandKeyHere'
  ),
));

        $response = json_decode(curl_exec($curl));
        curl_close($curl);

        if (isset($response->status) && $response->status) {
            $user = User::find($user_id);
            if ($user) {
                $user->deposit_balance += $amount;
                $user->save();

                Payment::create([
                    'user_id' => $user_id,
                    'method' => 'Tele-earn',
                    'number' => $response->transaction_id ?? '',
                    'trxid' => $response->transaction_id ?? '',
                    'amount' => $amount,
                    'status' => 'Success',
                ]);

                $this->handleReferralCommissions($user, $amount, 1); // Referral bonus
            }

            return redirect()->route('dashboard')->with('success', "৳{$amount} successfully added to Deposit Balance!");
        }
    }

    return redirect()->route('dashboard')->with('error', 'Payment failed or canceled.');
}

    private function handleReferralCommissions($user, $amount, $level)
{
    if ($level > 4 || !$user->ref_by) {
        return;
    }

    $referrer = User::where('ref_code', $user->ref_by)->first();

    if (!$referrer) {
        return;
    }

    // যদি level 1 হয় → ura + 1 হবে
    if ($level == 1) {
        $referrer->ura = $referrer->ura + 1;
    }

    // Commission calculation
    $commissionRates = [
        app('refer_level_1'),
        app('refer_level_2'),
        app('refer_level_3'),
        app('refer_level_4')
    ];

    $referralCommission = $commissionRates[$level - 1] * $amount;

    // Referrer balance update
    $referrer->balance += $referralCommission;

    // Save everything
    $referrer->save();

    // Next level process
    $this->handleReferralCommissions($referrer, $amount, $level + 1);
}


// ১. Reward System পেজে দেখানোর জন্য (আপনার rewardSystem() ফাংশনে এটা যোগ করুন বা আলাদা রাখুন)
public function rewardSystem()
{
    $user = Auth::user();
    $userActiveReferrals = $user->ura ?? 0;

    // পুরানো রিওয়ার্ড সিস্টেম (আপনার আগের কোড আছে)
    $rewardOffers = [
        '3' => env('REWARD_3_REFERRALS', 20),
        '5' => env('REWARD_5_REFERRALS', 50),
        '10' => env('REWARD_10_REFERRALS', 100),
        '20' => env('REWARD_20_REFERRALS', 200),
        '50' => env('REWARD_50_REFERRALS', 500)
    ];

    $eligibleRewards = [];
    foreach ($rewardOffers as $threshold => $amount) {
        if ($userActiveReferrals >= (int)$threshold) {
            $eligibleRewards[$threshold] = $amount;
        }
    }

    // নতুন: user_active == 1 হলে ৩ টাকা বোনাস
    $newBonusAmount = env('USER_ACTIVE_BONUS', 3); // .env এ রাখতে পারেন
    $canClaimNewBonus = false;
    $alreadyClaimedNewBonus = false;

    if ($user->user_active == 1) {
        $claimedRewards = $user->claimed_rewards 
            ? json_decode($user->claimed_rewards, true) 
            : [];

        $alreadyClaimedNewBonus = is_array($claimedRewards) && in_array('user_active_bonus', $claimedRewards);
        $canClaimNewBonus = !$alreadyClaimedNewBonus;
    }

    // পুরানো ক্লেইমড রিওয়ার্ড
    $claimedRewards = [];
    if (!empty($user->claimed_rewards)) {
        $claimedRewards = is_string($user->claimed_rewards) 
            ? json_decode($user->claimed_rewards, true) ?? [] 
            : (array)$user->claimed_rewards;
    }

    return view('user.reward-system', compact(
        'user', 'rewardOffers', 'eligibleRewards', 'userActiveReferrals', 'claimedRewards',
        'newBonusAmount', 'canClaimNewBonus', 'alreadyClaimedNewBonus'
    ));
}

    public function claimReward(Request $request)
{
    $user = Auth::user();
    $threshold = $request->threshold;

    $rewardAmounts = [
        '3'  => env('REWARD_3_REFERRALS', 20),
        '5'  => env('REWARD_5_REFERRALS', 50),
        '10' => env('REWARD_10_REFERRALS', 100),
        '20' => env('REWARD_20_REFERRALS', 200),
        '50' => env('REWARD_50_REFERRALS', 500)
    ];

    if (!isset($rewardAmounts[$threshold])) {
        return back()->with('error', 'Invalid reward selected.');
    }

    $amount = $rewardAmounts[$threshold];
    $required = (int)$threshold;

    if ($user->ura < $required) {
        return back()->with('error', 'Not enough active referrals.');
    }

    $claimedRewards = $user->claimed_rewards ? json_decode($user->claimed_rewards, true) : [];
    if (in_array($threshold, $claimedRewards)) {
        return back()->with('error', 'You have already claimed this reward.');
    }

    DB::beginTransaction();
    try {
        // Generate Unique Gift Code
        do {
            $code = strtoupper(substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 12));
        } while (GiftCode::where('code', $code)->exists());

        GiftCode::create([
            'code'        => $code,
            'amount'      => $amount,
            'max_uses'    => 1,
            'used_count'  => 0,
            'valid_from'  => now(),
            'valid_until' => now()->addYears(5),
        ]);

        // Mark as claimed
        $claimedRewards[] = $threshold;
        $user->claimed_rewards = json_encode($claimedRewards);
        $user->save();

        DB::commit();

        return redirect()->back()->with('giftcode_success', [
            'code' => $code
        ])->with('success', "You have received {$amount} Taka as Gift Code!");

    } catch (\Exception $e) {
        DB::rollback();
        return back()->with('error', 'Something went wrong. Please try again.');
    }
}

// ২. নতুন বোনাস ক্লেইম করার ফাংশন
public function claimUserActiveBonus(Request $request)
{
    $user = Auth::user();

    // চেক: user_active == 1 কিনা
    if ($user->user_active != 1) {
        return back()->with('error', 'You are not eligible for this bonus.');
    }

    // চেক: ইতিমধ্যে ক্লেইম করা হয়েছে কিনা
    $claimedRewards = $user->claimed_rewards 
        ? json_decode($user->claimed_rewards, true) 
        : [];

    if (is_array($claimedRewards) && in_array('user_active_bonus', $claimedRewards)) {
        return back()->with('error', 'You have already claimed this bonus!');
    }

    DB::beginTransaction();
    try {
        // ইউনিক গিফট কোড জেনারেট
        do {
            $code = strtoupper(substr(str_shuffle('ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 12));
        } while (GiftCode::where('code', $code)->exists());

        $amount = env('USER_ACTIVE_BONUS', 3); // ৩ টাকা বা যা চান

        GiftCode::create([
            'code' => $code,
            'amount' => $amount,
            'max_uses' => 1,
            'used_count' => 0,
            'valid_from' => now(),
            'valid_until' => now()->addYears(5),
        ]);

        // মার্ক এজ ক্লেইমড
        $claimedRewards[] = 'user_active_bonus';
        $user->claimed_rewards = json_encode($claimedRewards);
        $user->save();

        DB::commit();

        return redirect()->back()->with('giftcode_success', [
            'code' => $code
        ])->with('success', "অভিনন্দন! আপনি {$amount} টাকার বোনাস ক্লেইম করেছেন!");

    } catch (\Exception $e) {
        DB::rollback();
        return back()->with('error', 'কিছু ভুল হয়েছে। আবার চেষ্টা করুন।');
    }
}

 public function insert()
    {
        // Zero Task
        $taskReset = User::query()->update(['today_job' => '0']);
        
        $currentDate = date("Y-m-d");
        $expire_user = User::where('pack_expire', '<', $currentDate)->update(['running_pack' => '0', 'pack_expire' => null]);
        
        $users = User::all();
        foreach ($users as $user) {
            if($user->pack_expire == null){
                if($user->user_active == '1'){
                    User::where('id', '=', $user->id)->update(['job_limit' => '5']);
                }else{
                    User::where('id', '=', $user->id)->update(['job_limit' => '0']);
                }
            }else{
                if($user->running_pack == '500'){
                    User::where('id', '=', $user->id)->update(['job_limit' => '2']);
                }elseif($user->running_pack == '1000'){
                    User::where('id', '=', $user->id)->update(['job_limit' => '4']);
                }
            }
        }
        
        
    }

}
