<?php

namespace App\Http\Controllers\user;

use App\Http\Controllers\Controller;
use App\Models\Job;
use App\Models\JobSubmit;
use App\Models\Notice;
use App\Models\Payment;
use App\Models\User;
use App\Models\Withdraw;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use App\Models\EarningHistory;

class TypingController extends Controller


public function getSentence(Request $request)
{
     if (auth()->user()->user_active == '0') {
        return redirect()->back()->with(['error' => 'Activate your account first.']);
    }
    
    
    $user = Auth::user();

  
    if ($user->user_active != 1) {
        return response()->json([
            'status' => 'inactive',
            'message' => 'Your account is not activated. Please activate to start typing.',
        ]);
    }


    $soldIds = DB::table('sentence_history')
        ->where('user_id', $user->id)
        ->pluck('sentence_id')
        ->toArray();


    $sentence = DB::table('sentences')
        ->whereNotIn('id', $soldIds)
        ->inRandomOrder()
        ->first();

    if (!$sentence) {
        return response()->json([
            'status' => 'done',
            'message' => 'All available sentences have already been sold by you.',
        ]);
    }

    return response()->json([
        'status' => 'ok',
        'sentence_id' => $sentence->id,
        'sentence' => $sentence->sentence,
    ]);
}
public function mining()
{
   
    $pendingHistories = EarningHistory::where('user_id', Auth::id())
        ->where('type', 'pending')
        ->get();

    $collectedHistories = EarningHistory::where('user_id', Auth::id())
        ->where('type', 'collected')
        ->get();

    $allHistories = $pendingHistories->merge($collectedHistories)->sortByDesc('collected_at');

    return view('user.mining', compact('allHistories'));
}




public function collect()
{
    $user = auth()->user();

    if ($user->pending_earning > 0) {
      
        EarningHistory::create([
            'user_id'       => $user->id,
            'earned_amount' => $user->pending_earning,
            'collected_at'  => now(),
            'type'          => 'collected',
        ]);

        $user->balance += $user->pending_earning;
        $user->pending_earning = 0;
        $user->save();
    }

    $totalCollected = EarningHistory::where('user_id', $user->id)
        ->where('type', 'collected')
        ->sum('earned_amount');

    return redirect()->route('mining')->with([
        'success' => 'Earning collected!',
        'total_collected' => $totalCollected
    ]);
}

public function addEarnings()
{
    $now = Carbon::now();
    $users = User::where('user_active', 1)->get();
    $amountSetting = DB::table('settings')->where('key', 'mining_income')->value('value');
    
    foreach ($users as $user) {
        if (!$user->last_earning_time) {
            $user->last_earning_time = $now;
            $user->save();
            continue;
        }

        
        $diff = $now->diffInMinutes($user->last_earning_time);

       
        if ($diff >= 180) {
            $earnedAmount = $amountSetting; 
            $user->pending_earning += $earnedAmount;
            $user->last_earning_time = $now;
            $user->save();

           
            EarningHistory::create([
                'user_id' => $user->id,
                'earned_amount' => $earnedAmount,
                'collected_at' => $now, 
                'type' => 'pending',
            ]);
        }
    }

    return response()->json(['message' => 'Earnings added']);
}


    
public function storeSentence(Request $request)
{
    $request->validate([
        'sentences'     => 'required|array',
        'sentence_ids'  => 'required|array',
    ]);

    $userId = Auth::id();
    $sentenceCount = count($request->sentences);


    $amountSetting = DB::table('settings')->where('key', 'per_sentence_amount')->value('value');
    $amountPerSentence = floatval($amountSetting ?? 2);

  
    foreach ($request->sentences as $index => $sentence) {
        DB::table('sentence_history')->insert([
            'user_id'     => $userId,
            'sentence_id' => $request->sentence_ids[$index],
            'sentence'    => $sentence,
            'created_at'  => now(),
            'updated_at'  => now(),
        ]);
    }

    DB::table('users')->where('id', $userId)->decrement('job_limit', $sentenceCount);

    
    $totalEarned = $sentenceCount * $amountPerSentence;
    DB::table('users')->where('id', $userId)->increment('balance', $totalEarned);

    return response()->json([
        'status' => 'success',
        'earned' => $totalEarned,
        'message' => "You earned ৳{$totalEarned} for submitting {$sentenceCount} sentences."
    ]);
}



}

