<?php

namespace App\Http\Controllers;

use App\Models\Admin;
use App\Models\Payment;
use App\Models\Setting;
use App\Models\User;
use App\Models\Notice;
use App\Models\GiftCode;
use App\Models\GiftCodeRedemption;
use App\Models\Job;
use App\Models\Ad;
use App\Models\LotteryParticipant;
use App\Models\ChannelOrder;
use App\Models\Withdraw;
use App\Models\Lottery;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use App\Models\Sentence;
use Illuminate\Support\Facades\Http;

class AdminController extends Controller
{
    //

    public function getLogin(){
        return view('auth.login');
    }
    public function taskSettings(){
        $data = Job::get();
        return view('dashboard.task_setting', compact('data'));
    }
    public function taskSettingsPost(Request $request){
        $data = Job::where('id', '=', $request->job_id)->update([
                "job_title" => $request->job_title,
                "job_description" => $request->job_description,
                "amount" => $request->amount,
                "task_url" => $request->task_url,
            ]);
        return redirect()->route('taskSettings')->with('success', "Task success");
    }
    
    public function channelOrders()
{
    $orders = ChannelOrder::with('user')->orderBy('created_at', 'desc')->get();
    return view('admin.channel_orders', compact('orders'));
}

public function lotterySettings()
{
    $todayLottery = Lottery::where('lottery_date', today()->toDateString())->first();
    
    if (!$todayLottery) {
        $todayLottery = Lottery::create([
            'lottery_date' => today()->toDateString(),
            'join_amount' => 10,
            'first_prize' => 100,
            'second_prize' => 50,
            'third_prize' => 25
        ]);
    }

    // Get all lotteries for listing
    $allLotteries = Lottery::orderBy('lottery_date', 'desc')->get();

    return view('dashboard.lottery_settings', compact('todayLottery', 'allLotteries'));
}

public function lotterySettingsPost(Request $request)
{
    $request->validate([
        'join_amount' => 'required|numeric|min:0',
        'first_prize' => 'required|numeric|min:0',
        'second_prize' => 'required|numeric|min:0',
        'third_prize' => 'required|numeric|min:0',
    ]);

    $todayLottery = Lottery::where('lottery_date', today()->toDateString())->first();

    if ($todayLottery) {
        $todayLottery->update([
            'join_amount' => $request->join_amount,
            'first_prize' => $request->first_prize,
            'second_prize' => $request->second_prize,
            'third_prize' => $request->third_prize,
        ]);
    }

    return redirect()->route('lotterySettings')->with('success', 'Lottery settings updated successfully!');
}

public function runLotteryDraw()
{
    // 1. Pending Lottery Khuje Ber Kora
    // Logic: Emon lottery nin jeta complete hoyni EBONG tarikh ajke ba tar age (Rat 12 tai run hole ager diner ta nibe)
    $todayLottery = \App\Models\Lottery::where('is_completed', false)
        ->whereDate('lottery_date', '<=', now()->toDateString()) 
        ->orderBy('lottery_date', 'desc') // Latest ta age nibe
        ->first();

    // -- ERROR HANDLING FOR CRON & BROWSER --
    if (!$todayLottery) {
        $msg = 'No pending lottery found to draw.';
        // Jodi Console/Cron theke run hoy, text return korbe. Browser hole redirect.
        if (app()->runningInConsole()) { echo $msg . "\n"; return; }
        return redirect()->back()->with('error', $msg);
    }

    $participants = $todayLottery->participants()->get();

    if ($participants->count() < 3) {
        $msg = 'Need at least 3 participants to run the draw. Current: ' . $participants->count();
        if (app()->runningInConsole()) { echo $msg . "\n"; return; }
        return redirect()->back()->with('error', $msg);
    }

    // 2. Winner Selection Logic
    $winners = $participants->random(3);

    $prizes = [
        'first' => $todayLottery->first_prize,
        'second' => $todayLottery->second_prize,
        'third' => $todayLottery->third_prize
    ];

    $winnerData = [];
    $i = 0;
    foreach ($winners as $winner) {
        $prizeType = array_keys($prizes)[$i];
        $prizeAmount = $prizes[$prizeType];

        // Update Winner Table
        $winner->update([
            'has_won' => true,
            'prize_type' => $prizeType,
            'prize_amount' => $prizeAmount
        ]);

        // Add Balance to User
        $winner->user->increment('balance', $prizeAmount);

        // Prepare History Data
        $winnerData[] = [
            'user_id' => $winner->user_id,
            'user_name' => $winner->user->fname ?? 'User', // fname na thakle 'User'
            'prize_type' => $prizeType,
            'prize_amount' => $prizeAmount,
            'ticket_number' => $winner->ticket_number
        ];

        $i++;
    }

    // 3. Mark Current Lottery as Completed
    $todayLottery->update([
        'winners' => $winnerData,
        'is_completed' => true
    ]);

    // 4. Auto Create Next Day Lottery (Always create for tomorrow relative to real time)
    $tomorrowDate = now()->addDay()->toDateString();
    $tomorrowLottery = \App\Models\Lottery::where('lottery_date', $tomorrowDate)->first();

    if (!$tomorrowLottery) {
        \App\Models\Lottery::create([
            'lottery_date' => $tomorrowDate,
            'join_amount' => $todayLottery->join_amount,
            'first_prize' => $todayLottery->first_prize,
            'second_prize' => $todayLottery->second_prize,
            'third_prize' => $todayLottery->third_prize
        ]);
    }

    // -- SUCCESS RESPONSE --
    $successMsg = 'Lottery Draw Successful for Date: ' . $todayLottery->lottery_date;
    
    // Jodi server run kore, just message print korbe
    if (app()->runningInConsole()) {
        echo $successMsg . "\n";
        return;
    }

    // Jodi apni browser e click koren, redirect korbe
    return redirect()->route('lotterySettings')->with('success', $successMsg);
}

// নতুন লটারি তৈরি করার মেথড
public function createNewLottery(Request $request)
{
    $request->validate([
        'lottery_date' => 'required|date|unique:lotteries,lottery_date',
        'join_amount' => 'required|numeric|min:0',
        'first_prize' => 'required|numeric|min:0',
        'second_prize' => 'required|numeric|min:0',
        'third_prize' => 'required|numeric|min:0',
    ]);

    Lottery::create([
        'lottery_date' => $request->lottery_date,
        'join_amount' => $request->join_amount,
        'first_prize' => $request->first_prize,
        'second_prize' => $request->second_prize,
        'third_prize' => $request->third_prize
    ]);

    return redirect()->route('lotterySettings')->with('success', 'New lottery created successfully!');
}

// লটারি ডিলিট করার মেথড
public function deleteLottery($id)
{
    $lottery = Lottery::findOrFail($id);
    
    // শুধুমাত্র completed লটারি ডিলিট করা যাবে
    if ($lottery->is_completed) {
        $lottery->delete();
        return redirect()->route('lotterySettings')->with('success', 'Lottery deleted successfully!');
    } else {
        return redirect()->route('lotterySettings')->with('error', 'Cannot delete running lottery!');
    }
}

public function approveChannelOrder($id)
{
    $order = ChannelOrder::findOrFail($id);
    
    // Check if bot is admin in the channel
    $botToken = '8315254246:AAG3fcJgamO4L4rzr70bfngTn-kSXAnAoZ4';
    $channelUsername = ltrim($order->channel_username, '@');
    
    $apiUrl = "https://api.telegram.org/bot{$botToken}/getChatMember?chat_id=@{$channelUsername}&user_id=6802471785";
    
    try {
        $response = file_get_contents($apiUrl);
        $data = json_decode($response, true);
        
        if (isset($data['ok']) && $data['ok'] === true) {
            $order->update([
                'admin_approved' => true,
                'bot_admin' => true,
                'status' => 'approved'
            ]);
            
            return redirect()->back()->with('success', 'Order approved successfully!');
        } else {
            return redirect()->back()->with('error', 'Bot is not admin in this channel. Please add @ChatID_SB_Robot as admin first.');
        }
    } catch (\Exception $e) {
        return redirect()->back()->with('error', 'Verification failed. Please try again.');
    }
}

// Admin ads methods
public function adminAds()
{
    $pendingAds = Ad::with('user')->pending()->latest()->get();
    $activeAds = Ad::with('user')->active()->latest()->get();
    $allAds = Ad::with('user')->latest()->paginate(20);
    
    return view('admin.ads.index', compact('pendingAds', 'activeAds', 'allAds'));
}

public function approveAd($id)
{
    $ad = Ad::findOrFail($id);
    
    // Check if there's an active ad and schedule this one after it
    $lastActiveAd = Ad::active()->latest('end_time')->first();
    
    $startTime = now();
    if ($lastActiveAd && $lastActiveAd->end_time > now()) {
        $startTime = $lastActiveAd->end_time;
    }
    
    $endTime = $startTime->copy()->addHours($ad->duration_hours);
    
    $ad->update([
        'status' => 'approved',
        'start_time' => $startTime,
        'end_time' => $endTime
    ]);
    
    return redirect()->back()->with('success', 'Ad approved successfully.');
}

public function rejectAd($id)
{
    $ad = Ad::findOrFail($id);
    $ad->update(['status' => 'rejected']);
    
    return redirect()->back()->with('success', 'Ad rejected successfully.');
}

public function deleteAd($id)
{
    $ad = Ad::findOrFail($id);
    
    // Delete image file
    if (file_exists(public_path('ads_images/' . $ad->image))) {
        unlink(public_path('ads_images/' . $ad->image));
    }
    
    $ad->delete();
    
    return redirect()->back()->with('success', 'Ad deleted successfully.');
}

public function rejectChannelOrder($id)
{
    $order = ChannelOrder::findOrFail($id);
    $order->update(['status' => 'rejected']);
    
    // Refund user's balance
    $user = $order->user;
    $user->balance += $order->total_cost;
    $user->save();
    
    return redirect()->back()->with('success', 'Order rejected and amount refunded.');
}

public function completeChannelOrder($id)
{
    $order = ChannelOrder::findOrFail($id);
    $order->update(['status' => 'completed']);
    
    // Deduct amount from user's balance
    $user = $order->user;
    $user->total_spent += $order->total_cost;
    $user->save();
    
    return redirect()->back()->with('success', 'Order marked as completed.');
}

public function giftCodes()
{
    // creator relationship ছাড়াই data নিন
    $giftCodes = GiftCode::orderBy('created_at', 'desc')->get();
    return view('admin.gift_codes', compact('giftCodes'));
}

public function storeGiftCode(Request $request)
{
    $request->validate([
        'code' => 'required|string|max:255|unique:gift_codes,code',
        'amount' => 'required|numeric|min:0.01',
        'max_uses' => 'required|integer|min:1',
        'valid_from' => 'required|date',
        'valid_until' => 'required|date|after:valid_from'
    ]);

    GiftCode::create([
        'code' => strtoupper($request->code),
        'amount' => $request->amount,
        'max_uses' => $request->max_uses,
        'valid_from' => $request->valid_from,
        'valid_until' => $request->valid_until,
        'created_by' => Auth::guard('admin')->id()
    ]);

    return redirect()->back()->with('success', 'Gift code created successfully!');
}

public function toggleGiftCode($id)
{
    $giftCode = GiftCode::findOrFail($id);
    $giftCode->update(['is_active' => !$giftCode->is_active]);
    
    $status = $giftCode->is_active ? 'activated' : 'deactivated';
    return redirect()->back()->with('success', "Gift code {$status} successfully!");
}

public function deleteGiftCode($id)
{
    $giftCode = GiftCode::findOrFail($id);
    $giftCode->delete();
    
    return redirect()->back()->with('success', 'Gift code deleted successfully!');
}

public function giftCodeRedemptions()
{
    $redemptions = GiftCodeRedemption::with(['giftCode', 'user'])
        ->orderBy('redeemed_at', 'desc')
        ->paginate(20);
    
    return view('admin.gift_code_redemptions', compact('redemptions'));
}

public function channelSettings()
{
    $settings = DB::table('settings')
                 ->whereIn('key', ['min_channel_members', 'max_channel_members', 'cost_per_member', 'min_order_amount', 'max_orders_per_day'])
                 ->get()
                 ->keyBy('key');
    
    return view('admin.channel_settings', compact('settings'));
}

public function updateChannelSettings(Request $request)
{
    $request->validate([
        'min_channel_members' => 'required|integer|min:1',
        'max_channel_members' => 'required|integer|min:1',
        'cost_per_member' => 'required|numeric|min:0.01',
        'min_order_amount' => 'required|numeric|min:1',
        'max_orders_per_day' => 'required|integer|min:1'
    ]);

    foreach ($request->all() as $key => $value) {
        if (in_array($key, ['min_channel_members', 'max_channel_members', 'cost_per_member', 'min_order_amount', 'max_orders_per_day'])) {
            DB::table('settings')->updateOrInsert(
                ['key' => $key],
                ['value' => $value, 'updated_at' => now()]
            );
        }
    }

    return redirect()->back()->with('success', 'Channel settings updated successfully!');
}
    
     public function sindex()
{
    $totalSentences = Sentence::count();  

    return view('dashboard.sentences', compact('totalSentences'));
}
     public function sstore(Request $request)
{
    $request->validate([
        'amount' => 'required|integer|min:1|max:100',
    ]);

    $amount = $request->input('amount');
    $savedSentences = Sentence::pluck('sentence')->toArray();
    $newSentences = [];

    while (count($newSentences) < $amount) {
        $letterCount = rand(3, 5); 
        $randomLetters = array_rand(array_flip(range('A', 'Z')), $letterCount);

        if (!is_array($randomLetters)) {
            $randomLetters = [$randomLetters]; 
        }

        $words = array_map(function ($letter) {
            return $this->getWordStartingWith($letter);
        }, $randomLetters);

        $sentence = implode(' ', $words) . '.';
        $sentence = ucfirst(strtolower($sentence)); 

        if (!in_array($sentence, $savedSentences) && !in_array($sentence, $newSentences)) {
            $newSentences[] = $sentence;
        }

       
        if (count($newSentences) + count($savedSentences) > 1000) {
            break;
        }
    }

    foreach ($newSentences as $sentence) {
        Sentence::create([
            'sentence' => $sentence,
        ]);
    }

    return redirect()->route('sentences.index')->with('success', count($newSentences) . ", sentance Added Successful");
}

private function getWordStartingWith($letter)
{
   $dictionary = [
    'A' => ['Amazing', 'Awesome', 'Agile', 'Adventurous', 'Artistic', 'Ambitious', 'Affectionate', 'Authentic', 'Active', 'Astounding', 'Adaptable', 'Alert', 'Attentive', 'Attractive', 'Altruistic', 'Able', 'Approachable', 'Appreciative', 'Assertive', 'Aware', 'Affable', 'Amusing', 'Astonishing', 'Advanced', 'Amicable', 'Alluring', 'Academic', 'Admired', 'Accepting', 'Abundant'],
    'B' => ['Brave', 'Bright', 'Bold', 'Brilliant', 'Blessed', 'Balanced', 'Beautiful', 'Blissful', 'Benevolent', 'Bubbly', 'Brainy', 'Beloved', 'Big-hearted', 'Bold-minded', 'Broad-minded', 'Busy', 'Brisk', 'Blazing', 'Beneficial', 'Boisterous', 'Bountiful', 'Blazing', 'Beaming', 'Blended', 'Baronial', 'Bliss-making', 'Booming', 'Believable', 'Benevolent', 'Buoyant'],
    'C' => ['Clever', 'Creative', 'Calm', 'Confident', 'Caring', 'Cheerful', 'Charming', 'Compassionate', 'Considerate', 'Courageous', 'Curious', 'Captivating', 'Centered', 'Cool', 'Constructive', 'Composed', 'Credible', 'Classy', 'Cooperative', 'Colorful', 'Clear', 'Crisp', 'Conscious', 'Cultured', 'Cordial', 'Cute', 'Crystal-clear', 'Charismatic', 'Champion', 'Conscientious'],
    'D' => ['Daring', 'Delightful', 'Dynamic', 'Determined', 'Dedicated', 'Dazzling', 'Decent', 'Devoted', 'Disciplined', 'Desirable', 'Driven', 'Distinguished', 'Dutiful', 'Dreamy', 'Dependable', 'Decisive', 'Diverse', 'Diligent', 'Dramatic', 'Deep', 'Deserving', 'Divine', 'Dandy', 'Detailed', 'Durable', 'Developed', 'Dashing', 'Delicate', 'Definite', 'Diplomatic'],
    'E' => ['Energetic', 'Elegant', 'Excited', 'Empowered', 'Excellent', 'Effective', 'Eager', 'Efficient', 'Enchanting', 'Extraordinary', 'Enthusiastic', 'Earnest', 'Elated', 'Endearing', 'Empathetic', 'Elevated', 'Expressive', 'Experienced', 'Essential', 'Enlightened', 'Endless', 'Elite', 'Euphoric', 'Enriched', 'Evident', 'Emboldened', 'Empowering', 'Engaged', 'Epic', 'Enjoyable'],
    'F' => ['Funny', 'Friendly', 'Fast', 'Fabulous', 'Fantastic', 'Fearless', 'Fair', 'Faithful', 'Flexible', 'Focused', 'Flourishing', 'Fresh', 'Fascinating', 'Fierce', 'Fulfilling', 'Firm', 'Fragrant', 'Fortunate', 'Flawless', 'Feisty', 'Funky', 'Free', 'Famous', 'Festive', 'Fashionable', 'Fulfilled', 'Formidable', 'Foundational', 'Fluent', 'Fine'],
    'G' => ['Gentle', 'Great', 'Genuine', 'Generous', 'Gleeful', 'Gifted', 'Gracious', 'Gallant', 'Grounded', 'Glowing', 'Giving', 'Good-hearted', 'Gutsy', 'Giddy', 'Grateful', 'Golden', 'Growing', 'Glamorous', 'Grand', 'Glorious', 'Gigantic', 'Graceful', 'Grinning', 'Global', 'Giant', 'Glad', 'Game-changing', 'Genius', 'Guiding', 'Groovy'],
    'H' => ['Happy', 'Helpful', 'Honest', 'Hopeful', 'Humble', 'Healthy', 'Hardworking', 'Harmonious', 'Hearty', 'Heroic', 'Humorous', 'Handsome', 'Heartwarming', 'Healing', 'Heavenly', 'High-spirited', 'Huggable', 'Heartfelt', 'Historic', 'Hotshot', 'High-class', 'Handy', 'Heartening', 'Humanitarian', 'Honed', 'Handcrafted', 'Handpicked', 'Highly-rated', 'Heedful', 'Holistic'],
    'I' => ['Incredible', 'Innovative', 'Intelligent', 'Inspiring', 'Impressive', 'Idealistic', 'Important', 'Imaginative', 'Inviting', 'Intuitive', 'Independent', 'Illuminating', 'Intense', 'Interesting', 'Informative', 'Industrious', 'Inclusive', 'Influential', 'Infinite', 'Introspective', 'Intentional', 'Immense', 'Infallible', 'Iconic', 'Intrepid', 'Interactive', 'Inspired', 'Immaculate', 'Indulgent', 'Illustrious'],
    'J' => ['Joyful', 'Jolly', 'Just', 'Jubilant', 'Judicious', 'Jazzy', 'Jovial', 'Juicy', 'Joyous', 'Joking', 'Jumping', 'Jaunty', 'Joint', 'Jocund', 'Jammed', 'Jeweled', 'Jumpy', 'Justified', 'Jaw-dropping', 'Jungle-like', 'Jovial-hearted', 'Jubilating', 'Jitter-free', 'Jingling', 'Juvenescent', 'Jet-setting', 'Jewel-like', 'Jackpot', 'Joy-spreading', 'Jargon-free'],
    'K' => ['Kind', 'Knowledgeable', 'Keen', 'Kingly', 'Kinetic', 'Kindhearted', 'Kicky', 'Key', 'Kempt', 'Knightly', 'Knowing', 'Knockout', 'Kooky', 'Kaleidoscopic', 'Kingly-minded', 'Kept', 'Keen-eyed', 'Kool', 'Kingly-spirited', 'Kite-like', 'Keystone', 'Kickass', 'Kaleidoscope-minded', 'Kingly-wise', 'Keen-witted', 'Kosmic', 'Kindling', 'Karmic', 'Kickstarting', 'Keen-souled'],
    'L' => ['Loyal', 'Lovely', 'Lively', 'Lucky', 'Likeable', 'Logical', 'Legendary', 'Luxurious', 'Learned', 'Leading', 'Lighthearted', 'Laid-back', 'Limitless', 'Luminous', 'Level-headed', 'Lush', 'Laughing', 'Likable', 'Lyrical', 'Loyal-hearted', 'Light-filled', 'Lucid', 'Loyal-minded', 'Long-lasting', 'Loving', 'Large-hearted', 'Light-bringing', 'Leveling', 'Lean', 'Limit-breaking'],
    'M' => ['Mighty', 'Magical', 'Modern', 'Motivated', 'Mindful', 'Marvelous', 'Majestic', 'Mature', 'Meaningful', 'Meticulous', 'Modest', 'Multitalented', 'Memorable', 'Merry', 'Methodical', 'Magnificent', 'Magnetizing', 'Matchless', 'Masterful', 'Movable', 'Massive', 'Model', 'Miraculous', 'Moving', 'Mission-focused', 'Measured', 'Mind-expanding', 'Momentum-driven', 'Mirthful', 'Mystical'],
    'N' => ['Nice', 'Noble', 'Neat', 'Notable', 'Nurturing', 'Natural', 'Nonstop', 'Novel', 'Nimble', 'Nifty', 'Necessary', 'Nonjudgmental', 'Nonchalant', 'Noteworthy', 'Nurtured', 'Neat-handed', 'Navigating', 'Nimble-minded', 'Never-give-up', 'Neighborly', 'Non-toxic', 'Nourishing', 'No-nonsense', 'Nonviolent', 'Noticeable', 'Neon-bright', 'Noble-hearted', 'Networked', 'Nudging', 'Nimble-hearted'],
    'O' => ['Optimistic', 'Outstanding', 'Open', 'Organized', 'Original', 'Observant', 'Overjoyed', 'Outgoing', 'Omniscient', 'Obliging', 'Objective', 'Ornamental', 'Overachieving', 'Open-hearted', 'One-of-a-kind', 'Orchestrated', 'Outstandingly-kind', 'Omnipresent', 'Optimal', 'On-point', 'Onward', 'Overflowing', 'Operative', 'Omnidirectional', 'Offbeat', 'Ongoing', 'Overdelivering', 'Out-of-this-world', 'Orbiting', 'Organic'],
    'P' => ['Positive', 'Powerful', 'Peaceful', 'Playful', 'Passionate', 'Productive', 'Proactive', 'Perfect', 'Proud', 'Practical', 'Promising', 'Prepared', 'Persistent', 'Patient', 'Perceptive', 'Precious', 'Prolific', 'Purposeful', 'Pioneering', 'Progressive', 'Profound', 'Polished', 'Persuasive', 'Philosophical', 'Praiseworthy', 'Persistent-hearted', 'Power-packed', 'Poised', 'Panoramic', 'People-first'],
    'Q' => ['Quick', 'Quiet', 'Quirky', 'Qualified', 'Quintessential', 'Questioning', 'Quick-thinking', 'Quick-witted', 'Quotable', 'Quixotic', 'Queenly', 'Quaint', 'Quaking', 'Quantum', 'Quenching', 'Quizzical', 'Quality-driven', 'Quick-paced', 'Quick-stepping', 'Quick-souled', 'Queue-free', 'Quiet-minded', 'Quasar-like', 'Quirky-minded', 'Quick-minded', 'Quick-drawing', 'Question-free', 'Quiet-smiling', 'Queue-breaking', 'Quilted'],
    'R' => ['Reliable', 'Respectful', 'Radiant', 'Resilient', 'Remarkable', 'Rational', 'Resourceful', 'Refreshing', 'Relaxed', 'Refined', 'Robust', 'Realistic', 'Reassuring', 'Receptive', 'Romantic', 'Ready', 'Relatable', 'Rejoicing', 'Revolutionary', 'Reasonable', 'Responsive', 'Rooted', 'Rare', 'Rewarding', 'Reflective', 'Righteous', 'Resolute', 'Roaring', 'Rejuvenated', 'Rich'],
    'S' => ['Smart', 'Strong', 'Sweet', 'Supportive', 'Skillful', 'Sincere', 'Steady', 'Secure', 'Stunning', 'Sensational', 'Sensitive', 'Successful', 'Stylish', 'Self-aware', 'Soulful', 'Simple', 'Sustainable', 'Satisfied', 'Spectacular', 'Sparkling', 'Selfless', 'Serene', 'Spiritual', 'Superb', 'Sophisticated', 'Strategic', 'Self-confident', 'Sharp', 'Stable', 'Savvy'],
    'T' => ['Talented', 'True', 'Thoughtful', 'Thankful', 'Thriving', 'Trustworthy', 'Tolerant', 'Transparent', 'Tenacious', 'Tactful', 'Timeless', 'Terrific', 'Tranquil', 'Transformational', 'Trailblazing', 'Tender', 'Team-oriented', 'Tasteful', 'Teachable', 'Trendsetting', 'Thrilled', 'Thrilling', 'Tuned-in', 'Transcendent', 'Triumphant', 'Top-tier', 'Truthful', 'Trophy-worthy', 'Timely', 'Targeted'],
    'U' => ['Unique', 'Useful', 'Uplifting', 'Understanding', 'Upbeat', 'Unstoppable', 'Ultimate', 'Unshakable', 'United', 'Unforgettable', 'Upstanding', 'Unbreakable', 'Unbiased', 'Uncommon', 'Upward', 'Unfazed', 'Undeniable', 'Unlimited', 'Unequaled', 'Upgraded', 'Unrivaled', 'Untouchable', 'User-friendly', 'Unflinching', 'Universal', 'Unwavering', 'Untamed', 'Unifying', 'Ultra-fast', 'Ultra-strong'],
    'V' => ['Valiant', 'Vibrant', 'Virtuous', 'Victorious', 'Vigorous', 'Visionary', 'Vivid', 'Vocal', 'Valued', 'Versatile', 'Valid', 'Visible', 'Vital', 'Vivacious', 'Venerable', 'Vantage', 'Voluntary', 'Volcanic', 'Verified', 'Velvety', 'Vanquishing', 'Viable', 'Vanguard', 'Venturing', 'Vibrating', 'Valuable', 'Vaulting', 'Vanilla-sweet', 'Voiceful', 'Vocalized'],
    'W' => ['Wise', 'Warm', 'Witty', 'Wonderful', 'Welcoming', 'Willing', 'Worthy', 'Winning', 'Wellness-focused', 'Well-balanced', 'Wholesome', 'Wistful', 'Well-informed', 'Well-respected', 'Watchful', 'Worshipful', 'Wandering', 'Worldly', 'Wanderlusting', 'Wealthy', 'Wild', 'Well-meaning', 'Well-liked', 'Wide-eyed', 'Warmhearted', 'Well-rooted', 'Wired', 'Wellspring', 'Winning-minded', 'Whole'],
    'X' => ['Xenial', 'Xenodochial', 'X-factor', 'Xenogenic', 'Xenoglossy', 'Xylographic', 'Xiphoid', 'Xenophile', 'Xenial-minded', 'Xceptional', 'Xenovative', 'Xenial-spirit', 'Xenobright', 'Xuberant', 'Xalted', 'Xpedited', 'Xemplary', 'Xpressive', 'Xpert', 'Xperienced', 'Xciting', 'Xact', 'Xenofree', 'Xpressive-minded', 'Xceptional-thinker', 'Xaminer', 'Xponential', 'Xdesigning', 'Xengineered', 'Xultant'],
    'Y' => ['Youthful', 'Yielding', 'Yummy', 'Yearning', 'Yare', 'Yenful', 'Yogic', 'Yonder-bound', 'Yen-driven', 'Yes-minded', 'Yield-worthy', 'Yogistic', 'Yardstick-like', 'Yoked', 'Yen-inclined', 'Yen-hungry', 'Yule-bright', 'Yen-seeking', 'Yellow-happy', 'Yesable', 'Yell-free', 'Yum-packed', 'Yay-worthy', 'Yin-balanced', 'Yard-friendly', 'Yule-loving', 'Youth-centeric', 'Yield-powered', 'Yield-strong', 'Yearful'],
    'Z' => ['Zealous', 'Zany', 'Zestful', 'Zippy', 'Zillionaire-minded', 'Zen-like', 'Zonal', 'Zappy', 'Zingy', 'Zebra-striped', 'Zodiac-driven', 'Zing-powered', 'Zooming', 'Zappy-minded', 'Zenith-bound', 'Zero-limited', 'Zinger', 'Zoom-focused', 'Zest-powered', 'Zipped', 'Zapped', 'Zodiac-minded', 'Zippy-minded', 'Zen-aligned', 'Zeal-powered', 'Zonal-driven', 'Zesty-hearted', 'Zoned-in', 'Zephyr-like', 'Zinger-filled'],
];

    $words = $dictionary[$letter] ?? [$letter . 'word'];
    return $words[array_rand($words)];
}

public function deleteAllSentences()
{
   Sentence::query()->delete();

    return redirect()->route('greset')->with('success', 'All sentences have been deleted.');
}
    
    public function greset()
{
    $userActiveDefault = Auth::user()->user_active ?? 0; // or your logic here
    return view('dashboard.resetors', compact('userActiveDefault'));
}

    public function ActSys()
{
    try {
        $result = DB::select("
            SELECT COLUMN_DEFAULT 
            FROM INFORMATION_SCHEMA.COLUMNS 
            WHERE table_name = 'users' 
              AND COLUMN_NAME = 'user_active' 
              AND table_schema = DATABASE()
        ");
        $currentDefault = $result[0]->COLUMN_DEFAULT ?? 0;

        $newDefault = $currentDefault == 1 ? 0 : 1;

        DB::statement("ALTER TABLE users ALTER COLUMN user_active SET DEFAULT $newDefault");

        return redirect()->back()->with('status', "Default value changed to $newDefault successfully!");
    } catch (\Exception $e) {
        Log::error('Default value change failed: ' . $e->getMessage());
        return redirect()->back()->with('error', 'Error changing default value.');
    }
}

    public function UpdateLeaders()
{
    try {
       
        DB::statement("
            UPDATE users u
            JOIN (
                SELECT ref_code,
                       (SELECT COUNT(*)
                        FROM users
                        WHERE ref_by = u.ref_code
                          AND user_active = 1) AS first_level_count
                FROM users u
            ) AS counts ON u.ref_code = counts.ref_code
            SET u.total_referral_count = counts.first_level_count
        ");

      
        return redirect()->back()->with('status', 'Leader Board updated successfully!');
    } catch (\Exception $e) {
       
        Log::error('Referral count update failed: ' . $e->getMessage());

       
        return redirect()->back()->with('error', 'Error updating Leader Board.');
    }
}
    
    
    public function ActiveUsers(){
        $data = User::where('user_active', '=', '1')->get();
        return view('dashboard.usersdata', compact('data'));
    }
    public function ActiveUser(Request $request){
        $data = User::where('id', '=', $request->id)->update(['deactive' => "no"]);
        return redirect()->route('ActiveUsers')->with('success', "Active success");
    }
    public function DectiveUser(Request $request){
        $data = User::where('id', '=', $request->id)->update(['deactive' => "yes"]);
        return redirect()->route('ActiveUsers')->with('success', "Deactive success");
    }
    public function WithdrawPaid(Request $request){
        $data = Withdraw::where('id', '=', $request->id)->update(['status' => "Success"]);
        return redirect()->route('AdminWithdraws')->with('success', "Paid success");
    }
    public function WithdrawFailed(Request $request){
        $data = Withdraw::where('id', '=', $request->id)->update(['status' => "Failed"]);
        $data = Withdraw::where('id', '=', $request->id)->get()->first();
        User::where('id', "=", $data->user_id)->increment('balance', $data->amount);
        
        return redirect()->route('AdminWithdraws')->with('success', "Failed success");
    }
    // Withdraw Summary Method
public function withdrawSummary()
{
    // Get withdraw statistics by method and status
    $withdrawStats = Withdraw::select('method', 'status', DB::raw('COUNT(*) as count'), DB::raw('SUM(amount) as total_amount'))
        ->groupBy('method', 'status')
        ->get();

    // Organize data by method
    $summary = [];
    $totalPending = 0;
    $totalSuccess = 0;
    $totalFailed = 0;

    foreach ($withdrawStats as $stat) {
        $method = $stat->method;
        
        if (!isset($summary[$method])) {
            $summary[$method] = [
                'pending_count' => 0,
                'pending_amount' => 0,
                'success_count' => 0,
                'success_amount' => 0,
                'failed_count' => 0,
                'failed_amount' => 0
            ];
        }

        if ($stat->status === 'Pending') {
            $summary[$method]['pending_count'] = $stat->count;
            $summary[$method]['pending_amount'] = $stat->total_amount;
            $totalPending += $stat->total_amount;
        } elseif ($stat->status === 'Success') {
            $summary[$method]['success_count'] = $stat->count;
            $summary[$method]['success_amount'] = $stat->total_amount;
            $totalSuccess += $stat->total_amount;
        } elseif ($stat->status === 'Failed') {
            $summary[$method]['failed_count'] = $stat->count;
            $summary[$method]['failed_amount'] = $stat->total_amount;
            $totalFailed += $stat->total_amount;
        }
    }

    return view('dashboard.withdraw_summary', compact('summary', 'totalPending', 'totalSuccess', 'totalFailed'));
}

// Bulk Withdraw Action Method
public function bulkWithdrawAction(Request $request)
{
    $request->validate([
        'action' => 'required|in:success,failed',
        'method' => 'required|string'
    ]);

    $withdraws = Withdraw::where('method', $request->method)
                        ->where('status', 'Pending')
                        ->get();

    $updatedCount = 0;

    foreach ($withdraws as $withdraw) {
        if ($request->action === 'success') {
            $withdraw->update(['status' => 'Success']);
            $updatedCount++;
        } elseif ($request->action === 'failed') {
            $withdraw->update(['status' => 'Failed']);
            // Refund user balance
            User::where('id', $withdraw->user_id)->increment('balance', $withdraw->amount);
            $updatedCount++;
        }
    }

    $actionText = $request->action === 'success' ? 'approved' : 'rejected';
    return redirect()->back()->with('success', "{$updatedCount} {$request->method} withdrawals {$actionText} successfully!");
}
    
    public function InActiveUsers(){
        $data = User::where('user_active', '=', '0')->get();
        return view('dashboard.usersdata', compact('data'));
    }

    public function AdminPayments(){
        $data = Payment::get();
        return view('dashboard.paymentsdata', compact('data'));
    }
    public function AdminWithdraws(){
        $data = Withdraw::get();
        return view('dashboard.withdrawssdata', compact('data'));
    }
    public function changepwd(){
        return view('dashboard.change_password');
    }
    
    public function NoticeAdmin(){
        $data = Notice::get();
        return view('dashboard.notice', compact('data'));
    }
    public function NoticeAdminDelete(Request $request){
        $data = Notice::where('id', '=', $request->id)->delete();
        return redirect()->route('NoticeAdmin')->with('success', "Delete success");
    }
    public function submitNotice(Request $request){
        $request->validate([
            'notice_title' => 'required',
            'notice_content' => 'required',
        ]);
        $data = Notice::create(["notice_title" => $request->notice_title, "notice_body" => $request->notice_content, ]);
        return redirect()->route('NoticeAdmin')->with('success', "Add success");
    }

    public function changepwdPost(Request $request){
        $request->validate([
            'old_password' => 'required',
            'new_password' => 'required|confirmed',
        ]);

        if(!Hash::check($request->old_password, Auth::guard('admin')->user()->password)){
            return back()->with("error", "Old Password Doesn't match!");
        }

        Admin::whereId(Auth::guard('admin')->user()->id)->update([
            'password' => Hash::make($request->new_password)
        ]);

        return back()->with("success", "Password changed successfully!");

    }

    public function systemSettings(){
        $settings = Setting::all()->pluck('value', 'key')->toArray();
        return view('dashboard.system_settings', ['settings' => $settings]);
    }

    public function systemSettingsPost(Request $request){
        $newSettings = $request->input('settings');

        foreach ($newSettings as $key => $value) {
            Setting::updateOrCreate(['key' => $key], ['value' => $value]);
        }

        return redirect()->route('systemSettings')->with('success', 'Settings updated successfully');
    }

    public function AdminDash(){
        $data = [
            'title' => 'Dashboard',
            'active_users' => User::where('user_active', '=', '1')->count(),
            'inactive_users' => User::where('user_active', '=', '0')->count(),
            'payments' => Payment::where('status', '=', 'Success')->sum('amount'),
            'withdraws' => Withdraw::where('status', '=', 'Success')->sum('amount')
        ];

        return view('dashboard.dashboard', $data);
    }

    public function postLogin(Request $request){
        $request->validate([
            'email' => 'required|email',
            'password' => 'required'
        ]);

        $remember = $request->input('remember', false);

        $validated = Auth::guard('admin')->attempt([
            'email' => $request->email,
            'password' => $request->password
        ], $remember);

        if($validated){
            return redirect()->route('AdminDash');
        }else{
            return redirect()->back()->with('error', 'These credentials do not match.');
        }
    }
}
