<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    protected function schedule(Schedule $schedule)
    {
        // অন্যান্য নিয়মিত কমান্ড:
        $schedule->command('mining:add-earnings')->hourly();
        $schedule->command('withdraw:daily-reset')->everyMinute();
        
        // --- লটারি ড্র ও ডেটা রিসেট সিকোয়েন্স (Rat 12:00 AM BD Time) ---
        
        // ১. 🏆 লটারি ড্র (সর্বোচ্চ অগ্রাধিকার): Rat 12:00 AM (00:00)
        // এই ফাংশনে শুধু উইনার সিলেকশন ও পেমেন্ট দেওয়ার কাজটি থাকবে।
        $schedule->call('App\Http\Controllers\AdminController@runLotteryDraw')
                 ->dailyAt('23:50') 
                 ->timezone('Asia/Dhaka');
                 
        // ২. ♻️ ডেইলি লিমিট রিসেট: Rat 12:03 AM (00:03)
        // ড্র শেষ হওয়ার পর পরই ইউজারদের দৈনিক লিমিট রিসেট হবে।
        $schedule->call('App\Http\Controllers\user\dashController@resetDailyLimits')
                 ->dailyAt('00:00') 
                 ->timezone('Asia/Dhaka');     
                 
        // ৩. 🆕 নতুন লটারি তৈরি: Rat 12:05 AM (00:05)
        // সব ড্র ও রিসেট শেষ হওয়ার পর পরের দিনের জন্য নতুন লটারি তৈরি হবে।
        $schedule->call('App\Http\Controllers\AdminController@createNewLottery')
                 ->dailyAt('00:09') 
                 ->timezone('Asia/Dhaka');     
    }

    protected function commands()
    {
        $this->load(__DIR__.'/Commands');
        require base_path('routes/console.php');
    }
}