<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\User;
use Carbon\Carbon;
use App\Models\EarningHistory;
use Illuminate\Support\Facades\DB;

class AddMiningEarnings extends Command
{
    protected $signature = 'mining:add-earnings';
    protected $description = 'Add mining earnings to active users every hour';

    public function handle()
{
    $now = Carbon::now();
    $amountSetting = DB::table('settings')->where('key', 'mining_income')->value('value');
    $users = User::where('user_active', 1)->get();

    foreach ($users as $user) {
        if (!$user->last_earning_time) {
            $user->last_earning_time = $now;
            $user->save();
            continue;
        }

        $lastTime = Carbon::parse($user->last_earning_time);
        $diffInHours = $lastTime->diffInHours($now);

       
        if ($diffInHours >= 1 && $user->pending_earning < 12) {
           
            $maxPossibleHours = floor((12 - $user->pending_earning) / $amountSetting);
            $hoursToAdd = min($diffInHours, $maxPossibleHours);

            if ($hoursToAdd > 0) {
                $totalEarned = $amountSetting * $hoursToAdd;

                $user->pending_earning += $totalEarned;
                $user->last_earning_time = $now;
                $user->save();

                for ($i = 1; $i <= $hoursToAdd; $i++) {
                    EarningHistory::create([
                        'user_id' => $user->id,
                        'earned_amount' => $amountSetting,
                        'collected_at' => $lastTime->addHour(),
                        'type' => 'pending',
                    ]);
                }

                $this->info("Added {$totalEarned} TK to user {$user->id}");
            } else {
                $user->last_earning_time = $now;
                $user->save();
            }
        }
    }

    return 0;
}
}

